/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.candlelight.core.registry.ObjectRegistry;
import net.satisfy.farm_and_charm.core.block.LineConnectingBlock;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class SideTableBlock
extends LineConnectingBlock {
    public static final BooleanProperty HAS_LANTERN = BooleanProperty.create((String)"has_lantern");
    public static final BooleanProperty HAS_BOOK = BooleanProperty.create((String)"has_book");
    public static final BooleanProperty HAS_LAMP = BooleanProperty.create((String)"has_lamp");
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.375, (double)0.0, (double)1.0, (double)0.625, (double)1.0), (BooleanOp)BooleanOp.OR);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)voxelShapeSupplier.get()));
        }
    });

    public SideTableBlock(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(state -> (Boolean)state.getValue((Property)HAS_LANTERN) != false || (Boolean)state.getValue((Property)HAS_LAMP) != false ? 15 : 0));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HAS_LANTERN, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_BOOK, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_LAMP, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.getValue((Property)FACING));
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.scheduleTick(pos, (Block)this, 1);
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HAS_LANTERN, HAS_BOOK, HAS_LAMP});
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (!world.isClientSide) {
            boolean isSneaking = player.isCrouching();
            if (player.getItemInHand(hand).is(Items.LANTERN) && !((Boolean)state.getValue((Property)HAS_LANTERN)).booleanValue() && !isSneaking) {
                world.setBlock(pos, (BlockState)state.setValue((Property)HAS_LANTERN, (Comparable)Boolean.valueOf(true)), 3);
                if (!player.getAbilities().instabuild) {
                    player.getItemInHand(hand).shrink(1);
                }
                world.playSound(null, pos, SoundEvents.LANTERN_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.sidedSuccess((boolean)false);
            }
            if (player.getItemInHand(hand).is(Items.BOOK) && !((Boolean)state.getValue((Property)HAS_BOOK)).booleanValue() && !isSneaking) {
                world.setBlock(pos, (BlockState)state.setValue((Property)HAS_BOOK, (Comparable)Boolean.valueOf(true)), 3);
                if (!player.getAbilities().instabuild) {
                    player.getItemInHand(hand).shrink(1);
                }
                world.playSound(null, pos, SoundEvents.BOOK_PUT, SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.sidedSuccess((boolean)false);
            }
            if (Block.byItem((Item)player.getItemInHand(hand).getItem()).equals(ObjectRegistry.LAMP.get()) && !((Boolean)state.getValue((Property)HAS_LAMP)).booleanValue() && !isSneaking) {
                world.setBlock(pos, (BlockState)state.setValue((Property)HAS_LAMP, (Comparable)Boolean.valueOf(true)), 3);
                if (!player.getAbilities().instabuild) {
                    player.getItemInHand(hand).shrink(1);
                }
                world.playSound(null, pos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.sidedSuccess((boolean)false);
            }
            if (isSneaking && ((Boolean)state.getValue((Property)HAS_LANTERN)).booleanValue()) {
                world.setBlock(pos, (BlockState)state.setValue((Property)HAS_LANTERN, (Comparable)Boolean.valueOf(false)), 3);
                SideTableBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.LANTERN));
                world.playSound(null, pos, SoundEvents.LANTERN_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.sidedSuccess((boolean)false);
            }
            if (isSneaking && ((Boolean)state.getValue((Property)HAS_BOOK)).booleanValue()) {
                world.setBlock(pos, (BlockState)state.setValue((Property)HAS_BOOK, (Comparable)Boolean.valueOf(false)), 3);
                SideTableBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.BOOK));
                world.playSound(null, pos, SoundEvents.WOOL_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.sidedSuccess((boolean)false);
            }
            if (isSneaking && ((Boolean)state.getValue((Property)HAS_LAMP)).booleanValue()) {
                world.setBlock(pos, (BlockState)state.setValue((Property)HAS_LAMP, (Comparable)Boolean.valueOf(false)), 3);
                SideTableBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ObjectRegistry.LAMP.get()));
                world.playSound(null, pos, SoundEvents.WOOD_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.sidedSuccess((boolean)false);
            }
        }
        return super.useItemOn(itemStack, state, world, pos, player, hand, blockHitResult);
    }
}

