/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.core.event;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.satisfy.candlelight.core.registry.ObjectRegistry;
import net.satisfy.candlelight.core.registry.SoundEventRegistry;
import org.jetbrains.annotations.Nullable;

public class CommonEvents {
    public static void init() {
        PlayerEvent.ATTACK_ENTITY.register(CommonEvents::attack);
        TickEvent.PLAYER_POST.register(player -> {
            boolean holdingLoveLetter;
            ItemStack main = player.getMainHandItem();
            ItemStack off = player.getOffhandItem();
            boolean bl = holdingLoveLetter = main.is((Item)ObjectRegistry.LOVE_LETTER_CLOSED.get()) || off.is((Item)ObjectRegistry.LOVE_LETTER_CLOSED.get());
            if (holdingLoveLetter && player.level().isClientSide() && player.tickCount % 5 == 0) {
                double dz;
                boolean isMoving;
                double dx = player.getX() - player.xOld;
                boolean bl2 = isMoving = dx * dx + (dz = player.getZ() - player.zOld) * dz > 0.001;
                if (isMoving && !player.isShiftKeyDown()) {
                    double yaw = Math.toRadians(player.getYRot());
                    double behindX = player.getX() - Math.sin(yaw) * 0.5;
                    double behindZ = player.getZ() + Math.cos(yaw) * 0.5;
                    double y = player.getY() + 0.1;
                    player.level().addParticle((ParticleOptions)ParticleTypes.HEART, behindX, y, behindZ, 0.0, 0.02, 0.0);
                }
            }
        });
    }

    public static EventResult attack(Player player, Level level, Entity target, InteractionHand hand, @Nullable EntityHitResult result) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is((Item)ObjectRegistry.COOKING_PAN_ITEM.get())) {
            level.playSound(null, target.getX(), target.getY(), target.getZ(), (SoundEvent)SoundEventRegistry.COOKING_POT_HIT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            target.hurt(level.damageSources().generic(), 5.0f);
            itemStack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(itemStack));
            itemStack.applyComponents(DataComponentMap.builder().set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.builder().add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, -2.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()).build());
            if (target instanceof Mob) {
                Mob mob = (Mob)target;
                mob.setTarget((LivingEntity)player);
            }
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }
}

