/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.forge.client.extensions;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.satisfy.candlelight.core.item.DyeableCandlelightArmorItem;
import net.satisfy.candlelight.core.registry.ArmorRegistry;
import org.jetbrains.annotations.NotNull;

public class DyeableCandlelightArmorExtensions
implements IClientItemExtensions {
    @NotNull
    public Model getGenericArmorModel(@NotNull LivingEntity entity, @NotNull ItemStack stack, @NotNull EquipmentSlot slot, @NotNull HumanoidModel<?> original) {
        Item item = stack.getItem();
        if (!(item instanceof DyeableCandlelightArmorItem)) {
            return original;
        }
        DyeableCandlelightArmorItem item2 = (DyeableCandlelightArmorItem)item;
        if (slot != item2.getEquipmentSlot()) {
            return original;
        }
        if (slot == EquipmentSlot.CHEST) {
            return ArmorRegistry.getDressModel((Item)item2, original.body, original.leftArm, original.rightArm, original.leftLeg, original.rightLeg);
        }
        if (slot == EquipmentSlot.LEGS) {
            return ArmorRegistry.getSuitModel((Item)item2, original.rightLeg, original.leftLeg);
        }
        return original;
    }

    public int getArmorLayerTintColor(@NotNull ItemStack stack, @NotNull LivingEntity entity, @NotNull ArmorMaterial.Layer layer, int layerIdx, int fallbackColor) {
        Item item = stack.getItem();
        if (!(item instanceof DyeableCandlelightArmorItem)) {
            return 0;
        }
        DyeableCandlelightArmorItem item2 = (DyeableCandlelightArmorItem)item;
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (tag.contains("Visible") && !tag.getBoolean("Visible")) {
            return 0;
        }
        if (layerIdx == 0) {
            return 0xFF000000 | item2.getColor(stack);
        }
        return -1;
    }
}

