/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.api.common.helper;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeHelper {
    public static VoxelShape combineAll(Collection<VoxelShape> shapes) {
        VoxelShape result = Shapes.empty();
        for (VoxelShape shape : shapes) {
            result = Shapes.join((VoxelShape)result, (VoxelShape)shape, (BooleanOp)BooleanOp.OR);
        }
        return result.optimize();
    }

    public static VoxelShape combineAll(VoxelShape ... shapes) {
        VoxelShape result = Shapes.empty();
        for (VoxelShape shape : shapes) {
            result = Shapes.join((VoxelShape)result, (VoxelShape)shape, (BooleanOp)BooleanOp.OR);
        }
        return result.optimize();
    }

    public static Map<Direction, VoxelShape> getRotatedShapes(VoxelShape shape) {
        return Arrays.stream(Direction.values()).collect(Collectors.toMap(Function.identity(), direction -> VoxelShapeHelper.rotateShape(shape, direction)));
    }

    public static Map<Direction, VoxelShape> getHorizontalRotatedShapes(VoxelShape shape) {
        return (Map)Util.make(new EnumMap(Direction.class), map -> {
            map.put(Direction.NORTH, shape);
            map.put(Direction.EAST, VoxelShapeHelper.rotateShapeHorizontal(shape, Direction.EAST));
            map.put(Direction.SOUTH, VoxelShapeHelper.rotateShapeHorizontal(shape, Direction.SOUTH));
            map.put(Direction.WEST, VoxelShapeHelper.rotateShapeHorizontal(shape, Direction.WEST));
        });
    }

    public static VoxelShape rotateShape(VoxelShape shape, Direction direction) {
        ArrayList rotatedPieces = new ArrayList();
        Vec3 vec3 = new Vec3(-0.5, -0.5, -0.5);
        shape.toAabbs().forEach(aabb -> {
            aabb = aabb.move(vec3.x, vec3.y, vec3.z);
            AABB rotated = switch (direction) {
                default -> throw new MatchException(null, null);
                case Direction.DOWN -> aabb;
                case Direction.UP -> new AABB(aabb.minX, -aabb.minY, -aabb.minZ, aabb.maxX, -aabb.maxY, -aabb.maxZ);
                case Direction.NORTH -> new AABB(aabb.minX, -aabb.minZ, aabb.minY, aabb.maxX, -aabb.maxZ, aabb.maxY);
                case Direction.SOUTH -> new AABB(-aabb.minX, -aabb.minZ, -aabb.minY, -aabb.maxX, -aabb.maxZ, -aabb.maxY);
                case Direction.WEST -> new AABB(aabb.minY, -aabb.minZ, -aabb.minX, aabb.maxY, -aabb.maxZ, -aabb.maxX);
                case Direction.EAST -> new AABB(-aabb.minY, -aabb.minZ, aabb.minX, -aabb.maxY, -aabb.maxZ, aabb.maxX);
            };
            rotatedPieces.add(Shapes.create((AABB)rotated.move(-vec3.x, -vec3.z, -vec3.z)));
        });
        return rotatedPieces.stream().reduce(Shapes.empty(), Shapes::or);
    }

    public static VoxelShape rotateShapeHorizontal(VoxelShape shape, Direction direction) {
        ArrayList rotatedPieces = new ArrayList();
        Vec3 vec3 = new Vec3(-0.5, -0.5, -0.5);
        shape.toAabbs().forEach(aabb -> {
            aabb = aabb.move(vec3.x, vec3.y, vec3.z);
            AABB rotated = switch (direction) {
                case Direction.NORTH -> aabb;
                case Direction.SOUTH -> new AABB(-aabb.minX, aabb.minY, -aabb.minZ, -aabb.maxX, aabb.maxY, -aabb.maxZ);
                case Direction.WEST -> new AABB(aabb.minZ, aabb.minY, -aabb.minX, aabb.maxZ, aabb.maxY, -aabb.maxX);
                case Direction.EAST -> new AABB(-aabb.minZ, aabb.minY, aabb.minX, -aabb.maxZ, aabb.maxY, aabb.maxX);
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(direction));
            };
            rotatedPieces.add(Shapes.create((AABB)rotated.move(-vec3.x, -vec3.z, -vec3.z)));
        });
        return rotatedPieces.stream().reduce(Shapes.empty(), Shapes::or);
    }

    private static double[] adjustValues(Direction direction, double minX, double minZ, double maxX, double maxZ) {
        switch (direction) {
            case WEST: {
                double temp_minX = minX;
                minX = 1.0 - maxX;
                double temp_minZ = minZ;
                minZ = 1.0 - maxZ;
                maxX = 1.0 - temp_minX;
                maxZ = 1.0 - temp_minZ;
                break;
            }
            case NORTH: {
                double temp_minX = minX;
                minX = minZ;
                minZ = 1.0 - maxX;
                maxX = maxZ;
                maxZ = 1.0 - temp_minX;
                break;
            }
            case SOUTH: {
                double temp_minX = minX;
                minX = 1.0 - maxZ;
                double temp_minZ = minZ;
                minZ = temp_minX;
                double temp_maxX = maxX;
                maxX = 1.0 - temp_minZ;
                maxZ = temp_maxX;
            }
        }
        return new double[]{minX, minZ, maxX, maxZ};
    }

    public static EnumMap<Direction.Axis, VoxelShape> rotateAxis(VoxelShape shape) {
        return new EnumMap<Direction.Axis, VoxelShape>((Map<Direction.Axis, VoxelShape>)ImmutableMap.of((Object)Direction.Axis.Y, (Object)shape, (Object)Direction.Axis.X, (Object)VoxelShapeHelper.rotateAxis(shape, Direction.Axis.X), (Object)Direction.Axis.Z, (Object)VoxelShapeHelper.rotateAxis(shape, Direction.Axis.Z)));
    }

    public static VoxelShape rotateAxis(VoxelShape shape, Direction.Axis axis) {
        if (axis == Direction.Axis.Y) {
            return shape;
        }
        HashSet rotatedShapes = new HashSet();
        shape.forAllBoxes((x1, y1, z1, x2, y2, z2) -> {
            y1 *= 16.0;
            y2 *= 16.0;
            x1 *= 16.0;
            x2 *= 16.0;
            z1 *= 16.0;
            z2 *= 16.0;
            if (axis == Direction.Axis.X) {
                rotatedShapes.add(Block.box((double)y1, (double)x1, (double)z1, (double)y2, (double)x2, (double)z2));
            } else {
                rotatedShapes.add(Block.box((double)x1, (double)z1, (double)y1, (double)x2, (double)z2, (double)y2));
            }
        });
        return (VoxelShape)rotatedShapes.stream().reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    }

    public static VoxelShape add(double x1, double y1, double z1, double x2, double y2, double z2, VoxelShape ... shapes) {
        HashSet result = new HashSet();
        for (VoxelShape shape : shapes) {
            shape.forAllBoxes((x, y, z, x3, y3, z3) -> result.add(Block.box((double)((x *= 16.0) + x1), (double)((y *= 16.0) + y1), (double)((z *= 16.0) + z1), (double)((x3 *= 16.0) + x2), (double)((y3 *= 16.0) + y2), (double)((z3 *= 16.0) + z2))));
        }
        return result.stream().reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).orElse(Shapes.empty());
    }
}

