/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.api.common.loot.condition;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Calendar;
import java.util.Set;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.valhelsia.valhelsia_core.core.registry.ValhelsiaLootConditions;
import org.jetbrains.annotations.NotNull;

public record DateCondition(int month, int startDay, int endDay) implements LootItemCondition
{
    public static final MapCodec<DateCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("month").forGetter(condition -> condition.month), (App)Codec.INT.fieldOf("start_day").forGetter(condition -> condition.startDay), (App)Codec.INT.fieldOf("end_day").forGetter(condition -> condition.endDay)).apply((Applicative)instance, DateCondition::new));

    public static LootItemCondition.Builder builder(int month, int startDay, int endDay) {
        return () -> new DateCondition(month, startDay, endDay);
    }

    @NotNull
    public LootItemConditionType getType() {
        return ValhelsiaLootConditions.DATE.get();
    }

    @NotNull
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of();
    }

    public boolean test(LootContext lootContext) {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == this.month && calendar.get(5) >= this.startDay && calendar.get(5) <= this.endDay;
    }
}

