/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonalphas.blockEntity;

import dev.cudzer.cobblemonalphas.block.ModBlocks;
import dev.cudzer.cobblemonalphas.config.ModConfig;
import dev.cudzer.cobblemonalphas.data.AlphaJsonDataManager;
import dev.cudzer.cobblemonalphas.entity.Alpha;
import dev.cudzer.cobblemonalphas.entity.spawner.AlphaSpawner;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;

public class AlphaSpawnBlockEntity
extends BlockEntity {
    protected static int ticks = 0;

    public AlphaSpawnBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.ALPHA_SPAWNER_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos blockPos, BlockState blockState, T t) {
        if (ticks++ % 40 == 0) {
            Optional opt = level.getEntities((EntityTypeTest)EntityType.PLAYER, new AABB(blockPos).inflate(8.0, 8.0, 8.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR).stream().findFirst();
            opt.ifPresent(player -> {
                level.setBlockAndUpdate(blockPos, Blocks.AIR.defaultBlockState());
                Map<ResourceLocation, Alpha> alphaMap = AlphaJsonDataManager.getRandomAlphaForBiome(level, (ResourceKey<Biome>)((ResourceKey)level.getBiome(blockPos).unwrapKey().get()), false);
                if (alphaMap == null || alphaMap.isEmpty()) {
                    return;
                }
                Alpha alpha = alphaMap.values().stream().toList().getFirst();
                AlphaSpawner.getInstance().spawnAlphaEntity(alpha, level, (Vec3i)blockPos, ModConfig.doHerdSpawning);
            });
        }
    }
}

