/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonalphas.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class PokemonUtils {
    public static final ResourceLocation ALPHA_ICON = ResourceLocation.fromNamespaceAndPath((String)"cobblemonalphas", (String)"textures/billboard/alpha_icon.png");

    public static void buildAlphaIcon(PoseStack poseStack, float x, float y, float width, float height, float scale) {
        PokemonUtils.draw(poseStack, Float.valueOf(x), Float.valueOf(y), Float.valueOf(height), Float.valueOf(width), scale);
    }

    private static void draw(@NotNull PoseStack matrixStack, @NotNull Number x, @NotNull Number y, @NotNull Number height, @NotNull Number width, float scale) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ALPHA_ICON);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.pushPose();
        matrixStack.scale(scale, scale, 1.0f);
        Matrix4f lastPose = matrixStack.last().pose();
        PokemonUtils.drawRectangle(lastPose, x.floatValue(), y.floatValue(), x.floatValue() + width.floatValue(), y.floatValue() + height.floatValue(), 0.0f / width.floatValue(), (0.0f + width.floatValue()) / width.floatValue(), 0.0f / height.floatValue(), (0.0f + height.floatValue()) / height.floatValue());
        matrixStack.popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void drawRectangle(@NotNull Matrix4f matrix, float x, float y, float endX, float endY, float minU, float maxU, float minV, float maxV) {
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(matrix, x, endY, 0.0f).setUv(minU, maxV);
        bufferbuilder.addVertex(matrix, endX, endY, 0.0f).setUv(maxU, maxV);
        bufferbuilder.addVertex(matrix, endX, y, 0.0f).setUv(maxU, minV);
        bufferbuilder.addVertex(matrix, x, y, 0.0f).setUv(minU, minV);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }
}

