/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.bar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.client.recipe_viewer.interfaces.IRecipeViewerIngredientHelper;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.item.ItemGaugeDropper;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.PacketDropperUse;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GuiTankBar<STACK>
extends GuiBar<TankInfoProvider<STACK>>
implements IRecipeViewerIngredientHelper {
    private List<Component> lastInfo = Collections.emptyList();
    @Nullable
    private Tooltip lastTooltip;

    public GuiTankBar(IGuiWrapper gui, TankInfoProvider<STACK> infoProvider, int x, int y, int width, int height, boolean horizontal) {
        super(TextureAtlas.LOCATION_BLOCKS, gui, infoProvider, x, y, width, height, horizontal);
    }

    protected abstract boolean isEmpty(STACK var1);

    @Nullable
    protected abstract PacketDropperUse.TankType getType(STACK var1);

    @Override
    public void updateTooltip(int mouseX, int mouseY) {
        Object stored = ((TankInfoProvider)this.getHandler()).getStack();
        if (this.isEmpty(stored)) {
            super.updateTooltip(mouseX, mouseY);
        } else {
            List<Component> info = this.getTooltip(stored);
            if (!info.equals(this.lastInfo)) {
                this.lastInfo = info;
                this.lastTooltip = TooltipUtils.create(info);
            }
            this.setTooltip(this.lastTooltip);
        }
    }

    protected List<Component> getTooltip(STACK stack) {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        Component tooltip = ((TankInfoProvider)this.getHandler()).getTooltip();
        if (tooltip != null) {
            tooltips.add(tooltip);
        }
        return tooltips;
    }

    protected abstract void applyRenderColor(GuiGraphics var1, STACK var2);

    protected abstract TextureAtlasSprite getIcon(STACK var1);

    @Override
    protected void renderBarOverlay(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks, double handlerLevel) {
        int displayInt;
        Object stored = ((TankInfoProvider)this.getHandler()).getStack();
        if (!this.isEmpty(stored) && (displayInt = (int)(handlerLevel * (double)((this.horizontal ? this.width : this.height) - 2))) > 0) {
            this.applyRenderColor(guiGraphics, stored);
            TextureAtlasSprite icon = this.getIcon(stored);
            if (this.horizontal) {
                this.drawTiledSprite(guiGraphics, this.relativeX + 1, this.relativeY + 1, this.height - 2, displayInt, this.height - 2, icon, GuiUtils.TilingDirection.DOWN_RIGHT);
            } else {
                this.drawTiledSprite(guiGraphics, this.relativeX + 1, this.relativeY + 1, this.height - 2, this.width - 2, displayInt, icon, GuiUtils.TilingDirection.DOWN_RIGHT);
            }
            MekanismRenderer.resetColor(guiGraphics);
        }
    }

    public void onClick(double mouseX, double mouseY, int button) {
        ItemStack stack = this.gui().getCarriedItem();
        IGuiWrapper iGuiWrapper = this.gui();
        if (iGuiWrapper instanceof GuiMekanismTile) {
            int index;
            PacketDropperUse.TankType tankType;
            GuiMekanismTile gui = (GuiMekanismTile)iGuiWrapper;
            if (!stack.isEmpty() && stack.getItem() instanceof ItemGaugeDropper && (tankType = this.getType(((TankInfoProvider)this.getHandler()).getStack())) != null && (index = ((TankInfoProvider)this.getHandler()).getTankIndex()) != -1) {
                PacketDropperUse.DropperAction action = button == 0 ? (Screen.hasShiftDown() ? PacketDropperUse.DropperAction.DUMP_TANK : PacketDropperUse.DropperAction.FILL_DROPPER) : PacketDropperUse.DropperAction.DRAIN_DROPPER;
                PacketUtils.sendToServer(new PacketDropperUse(gui.getTileEntity().getBlockPos(), action, tankType, index));
            }
        }
    }

    public boolean isValidClickButton(int button) {
        return button == 0 || button == 1;
    }

    @Override
    public Optional<?> getIngredient(double mouseX, double mouseY) {
        Object stack = ((TankInfoProvider)this.getHandler()).getStack();
        return this.isEmpty(stack) ? Optional.empty() : Optional.of(stack);
    }

    @Override
    public Rect2i getIngredientBounds(double mouseX, double mouseY) {
        return new Rect2i(this.getX() + 1, this.getY() + 1, this.width - 2, this.height - 2);
    }

    public static interface TankInfoProvider<STACK>
    extends GuiBar.IBarInfoHandler {
        @NotNull
        public STACK getStack();

        public int getTankIndex();
    }
}

