/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.scroll;

import java.util.List;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.scroll.GuiScrollList;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.client.render.MekanismRenderer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GuiInstallableScrollList<TYPE>
extends GuiScrollList {
    private final ResourceLocation texture;
    private final int textureWidth;
    private final int textureHeight;
    @Nullable
    protected TYPE selectedType;
    @Nullable
    protected ScreenRectangle cachedTooltipRect;

    protected GuiInstallableScrollList(IGuiWrapper gui, int x, int y, int height, ResourceLocation background, int backgroundSideSize, ResourceLocation texture, int textureWidth, int textureHeight) {
        super(gui, x, y, textureWidth + 8, height, textureHeight / 3, background, backgroundSideSize);
        this.texture = texture;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
    }

    protected abstract List<TYPE> getCurrentInstalled();

    protected abstract void drawName(GuiGraphics var1, TYPE var2, int var3);

    protected abstract ItemStack getRenderStack(TYPE var1);

    @Nullable
    public TYPE getSelection() {
        return this.selectedType;
    }

    @Override
    public boolean hasSelection() {
        return this.selectedType != null;
    }

    @Override
    protected int getMaxElements() {
        return this.getCurrentInstalled().size();
    }

    @Override
    protected void setSelected(int index) {
        List<TYPE> currentInstalled;
        if (index >= 0 && index < (currentInstalled = this.getCurrentInstalled()).size()) {
            this.setSelected(currentInstalled.get(index));
        }
    }

    protected abstract void setSelected(TYPE var1);

    @Override
    public void clearSelection() {
        this.setSelected(null);
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderForeground(guiGraphics, mouseX, mouseY);
        int currentSelection = this.getCurrentSelection();
        List<TYPE> currentInstalled = this.getCurrentInstalled();
        int max = Math.min(this.getFocusedElements(), currentInstalled.size());
        for (int i = 0; i < max; ++i) {
            this.drawName(guiGraphics, currentInstalled.get(currentSelection + i), 3 + i * this.elementHeight);
        }
    }

    protected void drawNameText(GuiGraphics guiGraphics, int y, Component name, int color, float scale) {
        this.drawScaledScrollingString(guiGraphics, name, 13, y, IFancyFontRenderer.TextAlignment.LEFT, color, this.barXShift - 16, 0, false, scale);
    }

    @Override
    @NotNull
    protected ScreenRectangle getTooltipRectangle(int mouseX, int mouseY) {
        return this.cachedTooltipRect == null ? super.getTooltipRectangle(mouseX, mouseY) : this.cachedTooltipRect;
    }

    @Nullable
    protected EnumColor getColor(TYPE type) {
        return null;
    }

    @Override
    public void renderElements(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        TYPE type;
        int i;
        List<TYPE> currentInstalled = this.getCurrentInstalled();
        int currentSelection = this.getCurrentSelection();
        int max = Math.min(this.getFocusedElements(), currentInstalled.size());
        for (i = 0; i < max; ++i) {
            type = currentInstalled.get(currentSelection + i);
            int multipliedElement = i * this.elementHeight;
            int shiftedY = this.getY() + 1 + multipliedElement;
            int j = 1;
            if (type == this.getSelection()) {
                j = 2;
            } else if (mouseX >= this.getX() + 1 && mouseX < this.getX() + this.barXShift - 1 && mouseY >= shiftedY && mouseY < shiftedY + this.elementHeight) {
                j = 0;
            }
            EnumColor color = this.getColor(type);
            if (color != null) {
                MekanismRenderer.color(guiGraphics, color);
            }
            guiGraphics.blit(this.texture, this.relativeX + 1, this.relativeY + 1 + multipliedElement, 0.0f, (float)(this.elementHeight * j), this.textureWidth, this.elementHeight, this.textureWidth, this.textureHeight);
            if (color == null) continue;
            MekanismRenderer.resetColor(guiGraphics);
        }
        for (i = 0; i < max; ++i) {
            type = currentInstalled.get(currentSelection + i);
            this.gui().renderItem(guiGraphics, this.getRenderStack(type), this.relativeX + 3, this.relativeY + 3 + i * this.elementHeight, 0.5f);
        }
    }
}

