/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab.window;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInsetElement;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.common.inventory.container.SelectedWindowData;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class GuiWindowCreatorTab<DATA_SOURCE, ELEMENT extends GuiWindowCreatorTab<DATA_SOURCE, ELEMENT>>
extends GuiInsetElement<DATA_SOURCE> {
    @NotNull
    private final Supplier<ELEMENT> elementSupplier;

    public GuiWindowCreatorTab(ResourceLocation overlay, IGuiWrapper gui, DATA_SOURCE dataSource, int x, int y, int height, int innerSize, boolean left, @NotNull Supplier<ELEMENT> elementSupplier) {
        super(overlay, gui, dataSource, x, y, height, innerSize, left);
        this.elementSupplier = elementSupplier;
    }

    public void onClick(double mouseX, double mouseY, int button) {
        this.openWindow(this.getNextWindowData());
    }

    private void openWindow(SelectedWindowData windowData) {
        GuiWindow window = this.createWindow(windowData);
        window.setTabListeners(this.getCloseListener(), this.getReAttachListener());
        this.disableTab();
        this.gui().addWindow(window);
    }

    @NotNull
    protected final Supplier<ELEMENT> getElementSupplier() {
        return this.elementSupplier;
    }

    public void adoptWindows(GuiWindow ... windows) {
        for (GuiWindow window : windows) {
            window.setTabListeners(this.getCloseListener(), this.getReAttachListener());
        }
    }

    protected void disableTab() {
        this.active = false;
    }

    protected Consumer<GuiWindow> getCloseListener() {
        return window -> {
            ((GuiWindowCreatorTab)this.elementSupplier.get()).active = true;
        };
    }

    protected Consumer<GuiWindow> getReAttachListener() {
        return window -> ((GuiWindowCreatorTab)this.elementSupplier.get()).disableTab();
    }

    protected abstract GuiWindow createWindow(SelectedWindowData var1);

    protected abstract SelectedWindowData getNextWindowData();

    protected List<SelectedWindowData> getValidWindows() {
        return List.of(this.getNextWindowData());
    }

    @Override
    public void openPinnedWindows() {
        super.openPinnedWindows();
        for (SelectedWindowData windowData : this.getValidWindows()) {
            if (!windowData.wasPinned()) continue;
            this.openWindow(windowData);
        }
    }
}

