/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.window;

import java.util.function.Supplier;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.SelectedWindowData;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class GuiConfirmationDialog
extends GuiWindow {
    private static final int PADDING = 5;
    private final IFancyFontRenderer.WrappedTextRenderer wrappedTextRenderer;

    private GuiConfirmationDialog(IGuiWrapper gui, int x, int y, int width, int height, IFancyFontRenderer.ReplaceableWrappedTextRenderer renderer, Runnable onConfirm, DialogType type) {
        super(gui, x, y, width, height, SelectedWindowData.WindowType.CONFIRMATION);
        this.wrappedTextRenderer = renderer.replaceFont(this);
        this.active = true;
        this.addChild(new TranslationButton(gui, this.relativeX + width / 2 - 51, this.relativeY + height - 24, 50, 18, MekanismLang.BUTTON_CANCEL, this::close));
        this.addChild(new TranslationButton(gui, this.relativeX + width / 2 + 1, this.relativeY + height - 24, 50, 18, MekanismLang.BUTTON_CONFIRM, (element, mouseX, mouseY) -> {
            onConfirm.run();
            return this.close(element, mouseX, mouseY);
        }, type.getColorSupplier()));
    }

    public static void show(IGuiWrapper gui, Component title, Runnable onConfirm, DialogType type) {
        int width = 140;
        IFancyFontRenderer.ReplaceableWrappedTextRenderer renderer = new IFancyFontRenderer.ReplaceableWrappedTextRenderer(gui, width, title);
        int height = 33 + renderer.getRequiredHeight(width - 10);
        gui.addWindow(new GuiConfirmationDialog(gui, (gui.getXSize() - width) / 2, (gui.getYSize() - height) / 2, width, height, renderer, onConfirm, type));
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderForeground(guiGraphics, mouseX, mouseY);
        this.wrappedTextRenderer.render(guiGraphics, this.relativeX + 5, this.relativeY + 6, this.width - 10, IFancyFontRenderer.TextAlignment.CENTER, this.titleTextColor());
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return true;
    }

    @Override
    protected boolean isFocusOverlay() {
        return true;
    }

    public static enum DialogType {
        NORMAL(() -> null),
        DANGER(() -> EnumColor.RED);

        private final Supplier<EnumColor> colorSupplier;

        private DialogType(Supplier<EnumColor> colorSupplier) {
            this.colorSupplier = colorSupplier;
        }

        public Supplier<EnumColor> getColorSupplier() {
            return this.colorSupplier;
        }
    }
}

