/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.key;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import net.minecraft.client.KeyMapping;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import org.jetbrains.annotations.Nullable;

@ParametersAreNotNullByDefault
public class MekKeyBinding
extends KeyMapping {
    @Nullable
    private final BiConsumer<KeyMapping, Boolean> onKeyDown;
    @Nullable
    private final Consumer<KeyMapping> onKeyUp;
    @Nullable
    private final BooleanSupplier toggleable;
    private final boolean repeating;
    private boolean lastState;

    MekKeyBinding(String description, IKeyConflictContext keyConflictContext, KeyModifier keyModifier, InputConstants.Key key, String category, @Nullable BiConsumer<KeyMapping, Boolean> onKeyDown, @Nullable Consumer<KeyMapping> onKeyUp, @Nullable BooleanSupplier toggleable, boolean repeating) {
        super(description, keyConflictContext, keyModifier, key, category);
        this.onKeyDown = onKeyDown;
        this.onKeyUp = onKeyUp;
        this.toggleable = toggleable;
        this.repeating = repeating;
    }

    private boolean isToggleable() {
        return this.toggleable != null && this.toggleable.getAsBoolean();
    }

    public void setDown(boolean value) {
        boolean state;
        if (this.isToggleable()) {
            if (value && this.isConflictContextAndModifierActive()) {
                super.setDown(!this.isDown());
            }
        } else {
            super.setDown(value);
        }
        if ((state = this.isDown()) != this.lastState || state && this.repeating) {
            if (state) {
                if (this.onKeyDown != null) {
                    this.onKeyDown.accept(this, this.lastState);
                }
            } else if (this.onKeyUp != null) {
                this.onKeyUp.accept(this);
            }
            this.lastState = state;
        }
    }

    public boolean isDown() {
        return this.isDown && (this.isConflictContextAndModifierActive() || this.isToggleable());
    }
}

