/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.EnumUtils;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class RenderResizableCuboid {
    private static final int[] combinedARGB = new int[EnumUtils.DIRECTIONS.length];
    private static final Vector3f NORMAL = new Vector3f(1.0f, 1.0f, 1.0f).normalize();
    private static final int X_AXIS_MASK = 1 << Direction.Axis.X.ordinal();
    private static final int Y_AXIS_MASK = 1 << Direction.Axis.Y.ordinal();
    private static final int Z_AXIS_MASK = 1 << Direction.Axis.Z.ordinal();

    private RenderResizableCuboid() {
    }

    public static void renderCube(MekanismRenderer.Model3D cube, PoseStack matrix, VertexConsumer buffer, int argb, int light, int overlay, FaceDisplay faceDisplay, Camera camera, @Nullable Vec3 renderPos) {
        Arrays.fill(combinedARGB, argb);
        RenderResizableCuboid.renderCube(cube, matrix, buffer, combinedARGB, light, overlay, faceDisplay, camera, renderPos);
    }

    public static void renderCube(MekanismRenderer.Model3D cube, PoseStack matrix, VertexConsumer buffer, int[] colors, int light, int overlay, FaceDisplay faceDisplay, Camera camera, @Nullable Vec3 renderPos) {
        TextureAtlasSprite[] sprites = new TextureAtlasSprite[6];
        int axisToRender = 0;
        if (renderPos != null && faceDisplay != FaceDisplay.BOTH) {
            Vec3 camPos = camera.getPosition();
            Vec3 minPos = renderPos.add((double)cube.minX, (double)cube.minY, (double)cube.minZ);
            Vec3 maxPos = renderPos.add((double)cube.maxX, (double)cube.maxY, (double)cube.maxZ);
            for (Direction direction : EnumUtils.DIRECTIONS) {
                TextureAtlasSprite sprite = cube.getSpriteToRender(direction);
                if (sprite == null) continue;
                Direction.Axis axis = direction.getAxis();
                Direction.AxisDirection axisDirection = direction.getAxisDirection();
                double planeLocation = switch (axisDirection) {
                    default -> throw new MatchException(null, null);
                    case Direction.AxisDirection.POSITIVE -> axis.choose(maxPos.x, maxPos.y, maxPos.z);
                    case Direction.AxisDirection.NEGATIVE -> axis.choose(minPos.x, minPos.y, minPos.z);
                };
                double cameraPosition = axis.choose(camPos.x, camPos.y, camPos.z);
                if (faceDisplay.front == (axisDirection == Direction.AxisDirection.POSITIVE)) {
                    if (!(cameraPosition >= planeLocation)) continue;
                    sprites[direction.ordinal()] = sprite;
                    axisToRender |= 1 << axis.ordinal();
                    continue;
                }
                if (!(cameraPosition <= planeLocation)) continue;
                sprites[direction.ordinal()] = sprite;
                axisToRender |= 1 << axis.ordinal();
            }
        } else {
            for (Vec3 direction : EnumUtils.DIRECTIONS) {
                TextureAtlasSprite sprite = cube.getSpriteToRender((Direction)direction);
                if (sprite == null) continue;
                sprites[direction.ordinal()] = sprite;
                axisToRender |= 1 << direction.getAxis().ordinal();
            }
        }
        if (axisToRender == 0) {
            return;
        }
        int xShift = Mth.floor((float)cube.minX);
        int yShift = Mth.floor((float)cube.minY);
        int zShift = Mth.floor((float)cube.minZ);
        float minX = cube.minX - (float)xShift;
        float minY = cube.minY - (float)yShift;
        float minZ = cube.minZ - (float)zShift;
        float maxX = cube.maxX - (float)xShift;
        float maxY = cube.maxY - (float)yShift;
        float maxZ = cube.maxZ - (float)zShift;
        int xDelta = RenderResizableCuboid.calculateDelta(minX, maxX);
        int yDelta = RenderResizableCuboid.calculateDelta(minY, maxY);
        int zDelta = RenderResizableCuboid.calculateDelta(minZ, maxZ);
        float[] xBounds = RenderResizableCuboid.getBlockBounds(xDelta, minX, maxX);
        float[] yBounds = RenderResizableCuboid.getBlockBounds(yDelta, minY, maxY);
        float[] zBounds = RenderResizableCuboid.getBlockBounds(zDelta, minZ, maxZ);
        matrix.pushPose();
        matrix.translate((float)xShift, (float)yShift, (float)zShift);
        PoseStack.Pose lastMatrix = matrix.last();
        Matrix4f matrix4f = lastMatrix.pose();
        NormalData normal = new NormalData(lastMatrix.normal(), NORMAL, faceDisplay);
        if ((axisToRender & X_AXIS_MASK) != 0) {
            RenderResizableCuboid.renderSideXAxis(buffer, colors, light, overlay, faceDisplay, xDelta, yDelta, zDelta, sprites, yBounds, zBounds, xBounds, matrix4f, normal);
        }
        if ((axisToRender & Y_AXIS_MASK) != 0) {
            RenderResizableCuboid.renderSideYAxis(buffer, colors, light, overlay, faceDisplay, xDelta, yDelta, zDelta, sprites, yBounds, zBounds, xBounds, matrix4f, normal);
        }
        if ((axisToRender & Z_AXIS_MASK) != 0) {
            RenderResizableCuboid.renderSideZAxis(buffer, colors, light, overlay, faceDisplay, xDelta, yDelta, zDelta, sprites, yBounds, zBounds, xBounds, matrix4f, normal);
        }
        matrix.popPose();
    }

    private static void renderSideZAxis(VertexConsumer buffer, int[] colors, int light, int overlay, FaceDisplay faceDisplay, int xDelta, int yDelta, int zDelta, TextureAtlasSprite[] sprites, float[] yBounds, float[] zBounds, float[] xBounds, Matrix4f matrix4f, NormalData normal) {
        boolean hasSouth;
        TextureAtlasSprite northSprite = sprites[Direction.NORTH.ordinal()];
        TextureAtlasSprite southSprite = sprites[Direction.SOUTH.ordinal()];
        boolean hasNorth = northSprite != null;
        boolean bl = hasSouth = southSprite != null;
        if (!hasNorth && !hasSouth) {
            return;
        }
        int colorNorth = colors[Direction.NORTH.ordinal()];
        int colorSouth = colors[Direction.SOUTH.ordinal()];
        int redNorth = FastColor.ARGB32.red((int)colorNorth);
        int greenNorth = FastColor.ARGB32.green((int)colorNorth);
        int blueNorth = FastColor.ARGB32.blue((int)colorNorth);
        int alphaNorth = FastColor.ARGB32.alpha((int)colorNorth);
        int redSouth = FastColor.ARGB32.red((int)colorSouth);
        int greenSouth = FastColor.ARGB32.green((int)colorSouth);
        int blueSouth = FastColor.ARGB32.blue((int)colorSouth);
        int alphaSouth = FastColor.ARGB32.alpha((int)colorSouth);
        for (int y = 0; y <= yDelta; ++y) {
            float maxVSouth;
            float minVSouth;
            float maxVNorth;
            float minVNorth;
            float y1 = yBounds[y];
            float y2 = yBounds[y + 1];
            float vBoundsMin = RenderResizableCuboid.minBound(y1, y2);
            float vBoundsMax = RenderResizableCuboid.maxBound(y1, y2);
            if (hasNorth) {
                minVNorth = northSprite.getV(1.0f - vBoundsMax);
                maxVNorth = northSprite.getV(1.0f - vBoundsMin);
            } else {
                minVNorth = 0.0f;
                maxVNorth = 0.0f;
            }
            if (hasSouth) {
                minVSouth = southSprite.getV(1.0f - vBoundsMax);
                maxVSouth = southSprite.getV(1.0f - vBoundsMin);
            } else {
                minVSouth = 0.0f;
                maxVSouth = 0.0f;
            }
            for (int x = 0; x <= xDelta; ++x) {
                float maxUSouth;
                float minUSouth;
                float maxUNorth;
                float minUNorth;
                float x1 = xBounds[x];
                float x2 = xBounds[x + 1];
                float uBoundsMin = RenderResizableCuboid.minBound(x2, x1);
                float uBoundsMax = RenderResizableCuboid.maxBound(x2, x1);
                if (hasNorth) {
                    minUNorth = northSprite.getU(uBoundsMin);
                    maxUNorth = northSprite.getU(uBoundsMax);
                } else {
                    minUNorth = 0.0f;
                    maxUNorth = 0.0f;
                }
                if (hasSouth) {
                    minUSouth = southSprite.getU(uBoundsMin);
                    maxUSouth = southSprite.getU(uBoundsMax);
                } else {
                    minUSouth = 0.0f;
                    maxUSouth = 0.0f;
                }
                if (hasNorth) {
                    float z1 = zBounds[0];
                    RenderResizableCuboid.drawFace(buffer, matrix4f, minUNorth, maxUNorth, minVNorth, maxVNorth, light, overlay, faceDisplay, normal, x1, y1, z1, x1, y2, z1, x2, y2, z1, x2, y1, z1, redNorth, greenNorth, blueNorth, alphaNorth);
                }
                if (!hasSouth) continue;
                float z2 = zBounds[zDelta + 1];
                RenderResizableCuboid.drawFace(buffer, matrix4f, minUSouth, maxUSouth, minVSouth, maxVSouth, light, overlay, faceDisplay, normal, x2, y1, z2, x2, y2, z2, x1, y2, z2, x1, y1, z2, redSouth, greenSouth, blueSouth, alphaSouth);
            }
        }
    }

    private static void renderSideXAxis(VertexConsumer buffer, int[] colors, int light, int overlay, FaceDisplay faceDisplay, int xDelta, int yDelta, int zDelta, TextureAtlasSprite[] sprites, float[] yBounds, float[] zBounds, float[] xBounds, Matrix4f matrix4f, NormalData normal) {
        boolean hasEast;
        TextureAtlasSprite westSprite = sprites[Direction.WEST.ordinal()];
        TextureAtlasSprite eastSprite = sprites[Direction.EAST.ordinal()];
        boolean hasWest = westSprite != null;
        boolean bl = hasEast = eastSprite != null;
        if (!hasWest && !hasEast) {
            return;
        }
        int westColor = colors[Direction.WEST.ordinal()];
        int eastColor = colors[Direction.EAST.ordinal()];
        int redWest = FastColor.ARGB32.red((int)westColor);
        int greenWest = FastColor.ARGB32.green((int)westColor);
        int blueWest = FastColor.ARGB32.blue((int)westColor);
        int alphaWest = FastColor.ARGB32.alpha((int)westColor);
        int redEast = FastColor.ARGB32.red((int)eastColor);
        int greenEast = FastColor.ARGB32.green((int)eastColor);
        int blueEast = FastColor.ARGB32.blue((int)eastColor);
        int alphaEast = FastColor.ARGB32.alpha((int)eastColor);
        for (int y = 0; y <= yDelta; ++y) {
            float maxVEast;
            float minVEast;
            float maxVWest;
            float minVWest;
            float y1 = yBounds[y];
            float y2 = yBounds[y + 1];
            float vBoundsMin = RenderResizableCuboid.minBound(y1, y2);
            float vBoundsMax = RenderResizableCuboid.maxBound(y1, y2);
            if (hasWest) {
                minVWest = westSprite.getV(1.0f - vBoundsMax);
                maxVWest = westSprite.getV(1.0f - vBoundsMin);
            } else {
                minVWest = 0.0f;
                maxVWest = 0.0f;
            }
            if (hasEast) {
                minVEast = eastSprite.getV(1.0f - vBoundsMax);
                maxVEast = eastSprite.getV(1.0f - vBoundsMin);
            } else {
                minVEast = 0.0f;
                maxVEast = 0.0f;
            }
            for (int z = 0; z <= zDelta; ++z) {
                float maxUEast;
                float minUEast;
                float maxUWest;
                float minUWest;
                float z1 = zBounds[z];
                float z2 = zBounds[z + 1];
                float uBoundsMin = RenderResizableCuboid.minBound(z2, z1);
                float uBoundsMax = RenderResizableCuboid.maxBound(z2, z1);
                if (hasWest) {
                    minUWest = westSprite.getU(uBoundsMin);
                    maxUWest = westSprite.getU(uBoundsMax);
                } else {
                    minUWest = 0.0f;
                    maxUWest = 0.0f;
                }
                if (hasEast) {
                    minUEast = eastSprite.getU(uBoundsMin);
                    maxUEast = eastSprite.getU(uBoundsMax);
                } else {
                    minUEast = 0.0f;
                    maxUEast = 0.0f;
                }
                if (hasWest) {
                    float x1 = xBounds[0];
                    RenderResizableCuboid.drawFace(buffer, matrix4f, minUWest, maxUWest, minVWest, maxVWest, light, overlay, faceDisplay, normal, x1, y1, z2, x1, y2, z2, x1, y2, z1, x1, y1, z1, redWest, greenWest, blueWest, alphaWest);
                }
                if (!hasEast) continue;
                float x2 = xBounds[xDelta + 1];
                RenderResizableCuboid.drawFace(buffer, matrix4f, minUEast, maxUEast, minVEast, maxVEast, light, overlay, faceDisplay, normal, x2, y1, z1, x2, y2, z1, x2, y2, z2, x2, y1, z2, redEast, greenEast, blueEast, alphaEast);
            }
        }
    }

    private static void renderSideYAxis(VertexConsumer buffer, int[] colors, int light, int overlay, FaceDisplay faceDisplay, int xDelta, int yDelta, int zDelta, TextureAtlasSprite[] sprites, float[] yBounds, float[] zBounds, float[] xBounds, Matrix4f matrix4f, NormalData normal) {
        boolean hasDown;
        TextureAtlasSprite upSprite = sprites[Direction.UP.ordinal()];
        TextureAtlasSprite downSprite = sprites[Direction.DOWN.ordinal()];
        boolean hasUp = upSprite != null;
        boolean bl = hasDown = downSprite != null;
        if (!hasUp && !hasDown) {
            return;
        }
        int downColor = colors[Direction.DOWN.ordinal()];
        int upColor = colors[Direction.UP.ordinal()];
        int redUp = FastColor.ARGB32.red((int)upColor);
        int greenUp = FastColor.ARGB32.green((int)upColor);
        int blueUp = FastColor.ARGB32.blue((int)upColor);
        int alphaUp = FastColor.ARGB32.alpha((int)upColor);
        int redDown = FastColor.ARGB32.red((int)downColor);
        int greenDown = FastColor.ARGB32.green((int)downColor);
        int blueDown = FastColor.ARGB32.blue((int)downColor);
        int alphaDown = FastColor.ARGB32.alpha((int)downColor);
        for (int z = 0; z <= zDelta; ++z) {
            float maxV;
            float minV;
            float maxVUp;
            float minVUp;
            float z1 = zBounds[z];
            float z2 = zBounds[z + 1];
            float vBoundsMin = RenderResizableCuboid.minBound(z2, z1);
            float vBoundsMax = RenderResizableCuboid.maxBound(z2, z1);
            if (hasUp) {
                minVUp = upSprite.getV(1.0f - vBoundsMax);
                maxVUp = upSprite.getV(1.0f - vBoundsMin);
            } else {
                minVUp = 0.0f;
                maxVUp = 0.0f;
            }
            if (hasDown) {
                minV = downSprite.getV(1.0f - vBoundsMax);
                maxV = downSprite.getV(1.0f - vBoundsMin);
            } else {
                minV = 0.0f;
                maxV = 0.0f;
            }
            for (int x = 0; x <= xDelta; ++x) {
                float maxU;
                float minU;
                float maxUUp;
                float minUUp;
                float x1 = xBounds[x];
                float x2 = xBounds[x + 1];
                float uBoundsMin = RenderResizableCuboid.minBound(x1, x2);
                float uBoundsMax = RenderResizableCuboid.maxBound(x1, x2);
                if (hasUp) {
                    minUUp = upSprite.getU(uBoundsMin);
                    maxUUp = upSprite.getU(uBoundsMax);
                } else {
                    minUUp = 0.0f;
                    maxUUp = 0.0f;
                }
                if (hasDown) {
                    minU = downSprite.getU(uBoundsMin);
                    maxU = downSprite.getU(uBoundsMax);
                } else {
                    minU = 0.0f;
                    maxU = 0.0f;
                }
                if (hasUp) {
                    float y2 = yBounds[yDelta + 1];
                    RenderResizableCuboid.drawFace(buffer, matrix4f, minUUp, maxUUp, minVUp, maxVUp, light, overlay, faceDisplay, normal, x1, y2, z1, x1, y2, z2, x2, y2, z2, x2, y2, z1, redUp, greenUp, blueUp, alphaUp);
                }
                if (!hasDown) continue;
                float y1 = yBounds[0];
                RenderResizableCuboid.drawFace(buffer, matrix4f, minU, maxU, minV, maxV, light, overlay, faceDisplay, normal, x1, y1, z2, x1, y1, z1, x2, y1, z1, x2, y1, z2, redDown, greenDown, blueDown, alphaDown);
            }
        }
    }

    private static float[] getBlockBounds(int delta, float start, float end) {
        float[] bounds = new float[2 + delta];
        bounds[0] = start;
        int offset = (int)start;
        for (int i = 1; i <= delta; ++i) {
            bounds[i] = i + offset;
        }
        bounds[delta + 1] = end;
        return bounds;
    }

    private static int calculateDelta(float min, float max) {
        int delta = (int)(max - (float)((int)min));
        if ((double)max % 1.0 == 0.0) {
            --delta;
        }
        return delta;
    }

    private static void drawFace(VertexConsumer buffer, Matrix4f matrix, float minU, float maxU, float minV, float maxV, int light, int overlay, FaceDisplay faceDisplay, NormalData normal, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, int red, int green, int blue, int alpha) {
        if (faceDisplay.front) {
            buffer.addVertex(matrix, x1, y1, z1).setColor(red, green, blue, alpha).setUv(minU, maxV).setOverlay(overlay).setLight(light).setNormal(normal.front.x(), normal.front.y(), normal.front.z());
            buffer.addVertex(matrix, x2, y2, z2).setColor(red, green, blue, alpha).setUv(minU, minV).setOverlay(overlay).setLight(light).setNormal(normal.front.x(), normal.front.y(), normal.front.z());
            buffer.addVertex(matrix, x3, y3, z3).setColor(red, green, blue, alpha).setUv(maxU, minV).setOverlay(overlay).setLight(light).setNormal(normal.front.x(), normal.front.y(), normal.front.z());
            buffer.addVertex(matrix, x4, y4, z4).setColor(red, green, blue, alpha).setUv(maxU, maxV).setOverlay(overlay).setLight(light).setNormal(normal.front.x(), normal.front.y(), normal.front.z());
        }
        if (faceDisplay.back) {
            buffer.addVertex(matrix, x4, y4, z4).setColor(red, green, blue, alpha).setUv(maxU, maxV).setOverlay(overlay).setLight(light).setNormal(normal.back.x(), normal.back.y(), normal.back.z());
            buffer.addVertex(matrix, x3, y3, z3).setColor(red, green, blue, alpha).setUv(maxU, minV).setOverlay(overlay).setLight(light).setNormal(normal.back.x(), normal.back.y(), normal.back.z());
            buffer.addVertex(matrix, x2, y2, z2).setColor(red, green, blue, alpha).setUv(minU, minV).setOverlay(overlay).setLight(light).setNormal(normal.back.x(), normal.back.y(), normal.back.z());
            buffer.addVertex(matrix, x1, y1, z1).setColor(red, green, blue, alpha).setUv(minU, maxV).setOverlay(overlay).setLight(light).setNormal(normal.back.x(), normal.back.y(), normal.back.z());
        }
    }

    private static float minBound(float min, float max) {
        boolean bigger = min > max;
        min %= 1.0f;
        if (bigger) {
            return min == 0.0f ? 1.0f : min;
        }
        return min;
    }

    private static float maxBound(float min, float max) {
        boolean bigger = min > max;
        max %= 1.0f;
        if (bigger) {
            return max;
        }
        return max == 0.0f ? 1.0f : max;
    }

    public static enum FaceDisplay {
        FRONT(true, false),
        BACK(false, true),
        BOTH(true, true);

        private final boolean front;
        private final boolean back;

        private FaceDisplay(boolean front, boolean back) {
            this.front = front;
            this.back = back;
        }
    }

    private record NormalData(Vector3f front, Vector3f back) {
        private NormalData(Matrix3f normalMatrix, Vector3f normal, FaceDisplay faceDisplay) {
            this(faceDisplay.front ? NormalData.calculate(normalMatrix, normal.x(), normal.y(), normal.z()) : new Vector3f(), faceDisplay.back ? NormalData.calculate(normalMatrix, -normal.x(), -normal.y(), -normal.z()) : new Vector3f());
        }

        private static Vector3f calculate(Matrix3f normalMatrix, float x, float y, float z) {
            Vector3f matrixAdjustedNormal = new Vector3f(x, y, z);
            return matrixAdjustedNormal.mul((Matrix3fc)normalMatrix);
        }
    }
}

