/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.containers.chemical;

import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.chemical.AttachedChemicals;
import mekanism.common.attachments.containers.chemical.ComponentBackedChemicalTank;
import mekanism.common.item.block.ItemBlockChemicalTank;
import mekanism.common.tier.ChemicalTankTier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

@NothingNullByDefault
public class ComponentBackedChemicalTankTank
extends ComponentBackedChemicalTank {
    private final boolean isCreative;

    public static ComponentBackedChemicalTankTank create(ContainerType<?, ?, ?> ignored, ItemStack attachedTo, int tankIndex) {
        Item item = attachedTo.getItem();
        if (!(item instanceof ItemBlockChemicalTank)) {
            throw new IllegalStateException("Attached to should always be a chemical tank item");
        }
        ItemBlockChemicalTank item2 = (ItemBlockChemicalTank)item;
        return new ComponentBackedChemicalTankTank(attachedTo, tankIndex, item2.getTier());
    }

    private ComponentBackedChemicalTankTank(ItemStack attachedTo, int tankIndex, ChemicalTankTier tier) {
        super(attachedTo, tankIndex, ConstantPredicates.alwaysTrueBi(), ConstantPredicates.alwaysTrueBi(), ConstantPredicates.alwaysTrue(), tier::getOutput, tier::getStorage, tier == ChemicalTankTier.CREATIVE ? ChemicalAttributeValidator.ALWAYS_ALLOW : null);
        this.isCreative = tier == ChemicalTankTier.CREATIVE;
    }

    @Override
    public ChemicalStack insert(ChemicalStack stack, Action action, AutomationType automationType) {
        return super.insert(stack, action.combine(!this.isCreative), automationType);
    }

    @Override
    public ChemicalStack extract(AttachedChemicals attachedChemicals, ChemicalStack stored, long amount, Action action, AutomationType automationType) {
        return super.extract(attachedChemicals, stored, amount, action.combine(!this.isCreative), automationType);
    }

    @Override
    public long setStackSize(AttachedChemicals attachedChemicals, ChemicalStack stored, long amount, Action action) {
        return super.setStackSize(attachedChemicals, stored, amount, action.combine(!this.isCreative));
    }
}

