/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.containers.item;

import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.attachments.LockData;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.item.AttachedItems;
import mekanism.common.attachments.containers.item.ComponentBackedInventorySlot;
import mekanism.common.inventory.slot.BinInventorySlot;
import mekanism.common.item.block.ItemBlockBin;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tier.BinTier;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class ComponentBackedBinInventorySlot
extends ComponentBackedInventorySlot {
    private final boolean isCreative;

    public static ComponentBackedBinInventorySlot create(ContainerType<?, ?, ?> ignored, ItemStack attachedTo, int tankIndex) {
        Item item = attachedTo.getItem();
        if (!(item instanceof ItemBlockBin)) {
            throw new IllegalStateException("Attached to should always be a bin item");
        }
        ItemBlockBin item2 = (ItemBlockBin)item;
        return new ComponentBackedBinInventorySlot(attachedTo, tankIndex, item2.getTier());
    }

    private ComponentBackedBinInventorySlot(ItemStack attachedTo, int slotIndex, BinTier tier) {
        super(attachedTo, slotIndex, ConstantPredicates.alwaysTrueBi(), ConstantPredicates.alwaysTrueBi(), BinInventorySlot.validator, false, tier.getStorage());
        this.isCreative = tier == BinTier.CREATIVE;
    }

    @Override
    public ItemStack insertItem(AttachedItems attachedItems, ItemStack current, ItemStack stack, Action action, AutomationType automationType) {
        if (current.isEmpty()) {
            ItemStack lockStack = this.getLockStack();
            if (!lockStack.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)lockStack, (ItemStack)stack)) {
                return stack;
            }
            if (this.isCreative && action.execute() && automationType != AutomationType.EXTERNAL) {
                ItemStack simulatedRemainder = super.insertItem(attachedItems, current, stack, Action.SIMULATE, automationType);
                if (simulatedRemainder.isEmpty()) {
                    this.setContents(attachedItems, stack.copyWithCount(this.getLimit(stack)));
                }
                return simulatedRemainder;
            }
        }
        return super.insertItem(attachedItems, current, stack, action.combine(!this.isCreative), automationType);
    }

    @Override
    public ItemStack extractItem(int amount, Action action, AutomationType automationType) {
        return super.extractItem(amount, action.combine(!this.isCreative), automationType);
    }

    @Override
    protected int setStackSize(AttachedItems attachedItems, ItemStack current, int amount, Action action) {
        return super.setStackSize(attachedItems, current, amount, action.combine(!this.isCreative));
    }

    public ItemStack getBottomStack() {
        ItemStack current = this.getStack();
        if (current.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return current.copyWithCount(Math.min(current.getCount(), current.getMaxStackSize()));
    }

    public void setLockStack(@NotNull ItemStack stack) {
        if (stack.isEmpty()) {
            this.attachedTo.remove(MekanismDataComponents.LOCK);
        } else {
            this.attachedTo.set(MekanismDataComponents.LOCK, (Object)LockData.create(stack));
        }
    }

    public ItemStack getLockStack() {
        return ((LockData)this.attachedTo.getOrDefault(MekanismDataComponents.LOCK, (Object)LockData.EMPTY)).lock();
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = super.serializeNBT(provider);
        ItemStack lockStack = this.getLockStack();
        if (!lockStack.isEmpty()) {
            nbt.put("lock_stack", lockStack.save(provider));
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        NBTUtils.setItemStackOrEmpty(provider, nbt, "lock_stack", this::setLockStack);
        super.deserializeNBT(provider, nbt);
    }
}

