/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base.holiday;

import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.base.holiday.HolidayMessage;
import mekanism.common.base.holiday.KnownDate;
import mekanism.common.base.holiday.YearlyDate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public abstract class Holiday {
    private final KnownDate date;
    private boolean hasNotified;
    private boolean isToday;

    Holiday(KnownDate date) {
        this.date = date;
    }

    @Nullable
    HolidayMessage getMessage(Player player) {
        return null;
    }

    protected final boolean hasNotified() {
        return this.hasNotified;
    }

    final void notify(Player player) {
        HolidayMessage message = this.getMessage(player);
        if (message != null) {
            player.sendSystemMessage((Component)MekanismLang.HOLIDAY_BORDER.translate(message.themedLines(), EnumColor.DARK_BLUE, MekanismLang.GENERIC_SQUARE_BRACKET.translate(MekanismLang.MEKANISM)));
            for (Component line : message.lines()) {
                player.sendSystemMessage(line);
            }
            player.sendSystemMessage((Component)MekanismLang.HOLIDAY_BORDER.translate(message.themedLines(), EnumColor.DARK_BLUE, "[=======]"));
        }
        this.hasNotified = true;
    }

    final boolean updateIsToday(YearlyDate today) {
        this.isToday = this.date.isToday(today);
        if (!this.isToday) {
            this.hasNotified = false;
        }
        return this.isToday;
    }

    public final boolean isToday() {
        return this.isToday;
    }

    protected static Component getThemedLines(int amount, EnumColor ... colors) {
        MutableComponent component = Component.empty();
        for (int i = 0; i < amount; ++i) {
            component.append((Component)TextComponentUtil.build(colors[i % colors.length], "-"));
        }
        return component;
    }

    protected static Component getThemedLines(int amount, int ... colors) {
        MutableComponent component = Component.empty();
        for (int i = 0; i < amount; ++i) {
            component.append((Component)Component.literal((String)"-").withColor(colors[i % colors.length]));
        }
        return component;
    }
}

