/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.security;

import java.util.Objects;
import java.util.UUID;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.security.IOwnerObject;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.OwnerDisplay;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class OwnerObject
implements IOwnerObject {
    protected final ItemStack stack;

    public OwnerObject(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    @Nullable
    public UUID getOwnerUUID() {
        return (UUID)this.stack.get(MekanismDataComponents.OWNER);
    }

    @Override
    @Nullable
    public String getOwnerName() {
        UUID owner = this.getOwnerUUID();
        if (owner != null) {
            return OwnerDisplay.getOwnerName(MekanismUtils.tryGetClientPlayer(), owner, null);
        }
        return null;
    }

    @Override
    public void setOwnerUUID(@Nullable UUID owner) {
        UUID ownerUUID = this.getOwnerUUID();
        if (!Objects.equals(ownerUUID, owner)) {
            if (ownerUUID != null) {
                this.stack.remove(MekanismDataComponents.INVENTORY_FREQUENCY);
                this.stack.remove(MekanismDataComponents.TELEPORTER_FREQUENCY);
                this.stack.remove(MekanismDataComponents.QIO_FREQUENCY);
            }
            this.stack.set(MekanismDataComponents.OWNER, (Object)owner);
        }
    }
}

