/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.qio;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mekanism.common.Mekanism;
import mekanism.common.lib.MekanismSavedData;
import mekanism.common.lib.inventory.HashedItem;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QIOGlobalItemLookup {
    public static final QIOGlobalItemLookup INSTANCE = new QIOGlobalItemLookup();
    private static final String DATA_HANDLER_NAME = "qio_type_cache";
    @Nullable
    private QIOGlobalItemLookupDataHandler dataHandler;
    private BiMap<UUID, HashedItem> itemCache = HashBiMap.create();
    private Map<UUID, UUID> mergedIds = Collections.emptyMap();

    private QIOGlobalItemLookup() {
    }

    public boolean hasAliases() {
        return !this.mergedIds.isEmpty();
    }

    public UUID getWinningId(UUID uuid) {
        return this.mergedIds.getOrDefault(uuid, uuid);
    }

    @Nullable
    public UUID getUUIDForType(HashedItem item) {
        return (UUID)this.itemCache.inverse().get((Object)item);
    }

    public UUID getOrTrackUUID(HashedItem item) {
        SerializedHashedItem serializable = new SerializedHashedItem(item);
        BiMap inverseCache = this.itemCache.inverse();
        UUID uuid = (UUID)inverseCache.get((Object)serializable);
        if (uuid == null) {
            uuid = UUID.randomUUID();
            this.itemCache.put((Object)uuid, (Object)serializable);
            this.markDirty();
        }
        return uuid;
    }

    @Nullable
    public HashedItem getTypeByUUID(@Nullable UUID uuid) {
        return uuid == null ? null : (HashedItem)this.itemCache.get((Object)uuid);
    }

    private void markDirty() {
        if (this.dataHandler != null) {
            this.dataHandler.setDirty();
        }
    }

    public void createOrLoad() {
        if (this.dataHandler == null) {
            this.dataHandler = MekanismSavedData.createSavedData(QIOGlobalItemLookupDataHandler::new, DATA_HANDLER_NAME);
        }
    }

    public void reset() {
        this.itemCache = HashBiMap.create();
        this.dataHandler = null;
    }

    private static class SerializedHashedItem
    extends HashedItem {
        private Tag nbtRepresentation;

        private SerializedHashedItem(ItemStack stack) {
            super(stack);
        }

        protected SerializedHashedItem(HashedItem other) {
            super(other);
        }

        public Tag getNbtRepresentation(@NotNull HolderLookup.Provider provider) {
            if (this.nbtRepresentation == null) {
                this.nbtRepresentation = this.internalToNBT(provider);
                ((CompoundTag)this.nbtRepresentation).putByte("count", (byte)1);
            }
            return this.nbtRepresentation;
        }
    }

    private static class QIOGlobalItemLookupDataHandler
    extends MekanismSavedData {
        private QIOGlobalItemLookupDataHandler() {
        }

        @Override
        public void load(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
            boolean hasAliases = nbt.contains("aliases", 10);
            if (hasAliases) {
                this.loadAliases(nbt.getCompound("aliases"));
            }
            if (nbt.contains("items", 10)) {
                this.loadItemData(nbt.getCompound("items"), provider);
            } else if (!hasAliases) {
                this.loadItemData(nbt, provider);
            }
        }

        private void loadItemData(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
            for (String key : nbt.getAllKeys()) {
                UUID uuid;
                try {
                    uuid = UUID.fromString(key);
                }
                catch (IllegalArgumentException e) {
                    Mekanism.logger.warn("Invalid UUID ({}) stored in {} saved data.", (Object)key, (Object)QIOGlobalItemLookup.DATA_HANDLER_NAME);
                    continue;
                }
                ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbt.getCompound(key));
                if (stack.isEmpty()) {
                    Mekanism.logger.debug("Failed to read corresponding item for UUID ({}) stored in {} saved data. This most likely means the mod adding the item was removed.", (Object)uuid, (Object)QIOGlobalItemLookup.DATA_HANDLER_NAME);
                    continue;
                }
                SerializedHashedItem item = new SerializedHashedItem(stack);
                try {
                    QIOGlobalItemLookup.INSTANCE.itemCache.put((Object)uuid, (Object)item);
                }
                catch (IllegalArgumentException e) {
                    UUID winningId = (UUID)QIOGlobalItemLookup.INSTANCE.itemCache.inverse().get((Object)item);
                    if (winningId == null) {
                        Mekanism.logger.error("Failed to resolve conflict for UUID ({}) for item {} with components: {}. Skipping", new Object[]{uuid, stack.getItem(), stack.getComponentsPatch()});
                        continue;
                    }
                    Mekanism.logger.warn("Adding alias between UUID ({}) to ({}) for item {} with components: {}", new Object[]{uuid, winningId, stack.getItem(), stack.getComponentsPatch()});
                    if (QIOGlobalItemLookup.INSTANCE.mergedIds.isEmpty()) {
                        QIOGlobalItemLookup.INSTANCE.mergedIds = new HashMap<UUID, UUID>();
                    }
                    QIOGlobalItemLookup.INSTANCE.mergedIds.put(uuid, winningId);
                }
            }
        }

        private void loadAliases(CompoundTag tag) {
            if (!tag.isEmpty() && QIOGlobalItemLookup.INSTANCE.mergedIds.isEmpty()) {
                QIOGlobalItemLookup.INSTANCE.mergedIds = new HashMap<UUID, UUID>();
            }
            for (String key : tag.getAllKeys()) {
                try {
                    UUID uuid = UUID.fromString(key);
                    UUID winningId = tag.getUUID(key);
                    QIOGlobalItemLookup.INSTANCE.mergedIds.put(uuid, winningId);
                }
                catch (IllegalArgumentException e) {
                    Mekanism.logger.warn("Invalid alias UUID ({}) or winningId UUID stored in {} saved data.", (Object)key, (Object)QIOGlobalItemLookup.DATA_HANDLER_NAME);
                }
            }
        }

        @NotNull
        public CompoundTag save(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
            if (!QIOGlobalItemLookup.INSTANCE.mergedIds.isEmpty()) {
                CompoundTag aliases = new CompoundTag();
                for (Map.Entry<UUID, UUID> entry : QIOGlobalItemLookup.INSTANCE.mergedIds.entrySet()) {
                    aliases.putUUID(entry.getKey().toString(), entry.getValue());
                }
                nbt.put("aliases", (Tag)aliases);
            }
            if (!QIOGlobalItemLookup.INSTANCE.itemCache.isEmpty()) {
                CompoundTag items = new CompoundTag();
                for (Map.Entry<UUID, UUID> entry : QIOGlobalItemLookup.INSTANCE.itemCache.entrySet()) {
                    items.put(entry.getKey().toString(), ((SerializedHashedItem)((Object)entry.getValue())).getNbtRepresentation(provider));
                }
                nbt.put("items", (Tag)items);
            }
            return nbt;
        }
    }
}

