/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.api.recipes.basic.BasicRotaryRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.vanilla_input.RotaryRecipeInput;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.recipe.manager.MekanismRecipeManager;
import mekanism.common.recipe.MekanismRecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.manager.Rotary")
public class RotaryRecipeManager
extends MekanismRecipeManager<RotaryRecipeInput, RotaryRecipe> {
    public static final RotaryRecipeManager INSTANCE = new RotaryRecipeManager();

    private RotaryRecipeManager() {
        super(MekanismRecipeType.ROTARY);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, CTFluidIngredient fluidInput, ICrTChemicalStack chemicalOutput) {
        this.addRecipe(name, this.makeRecipe(fluidInput, chemicalOutput));
    }

    @ZenCodeType.Method
    public void addRecipe(String name, ChemicalStackIngredient chemicalInput, IFluidStack fluidOutput) {
        this.addRecipe(name, this.makeRecipe(chemicalInput, fluidOutput));
    }

    @ZenCodeType.Method
    public void addRecipe(String name, CTFluidIngredient fluidInput, ChemicalStackIngredient chemicalInput, ICrTChemicalStack chemicalOutput, IFluidStack fluidOutput) {
        this.addRecipe(name, this.makeRecipe(fluidInput, chemicalInput, chemicalOutput, fluidOutput));
    }

    public final RotaryRecipe makeRecipe(CTFluidIngredient fluidInput, ICrTChemicalStack chemicalOutput) {
        return new BasicRotaryRecipe(CrTUtils.fromCrT(fluidInput), this.getAndValidateNotEmpty(chemicalOutput));
    }

    public final RotaryRecipe makeRecipe(ChemicalStackIngredient chemicalInput, IFluidStack fluidOutput) {
        return new BasicRotaryRecipe(chemicalInput, this.getAndValidateNotEmpty(fluidOutput));
    }

    public final RotaryRecipe makeRecipe(CTFluidIngredient fluidInput, ChemicalStackIngredient chemicalInput, ICrTChemicalStack chemicalOutput, IFluidStack fluidOutput) {
        return new BasicRotaryRecipe(CrTUtils.fromCrT(fluidInput), chemicalInput, this.getAndValidateNotEmpty(chemicalOutput), this.getAndValidateNotEmpty(fluidOutput));
    }

    @Override
    protected String describeOutputs(RotaryRecipe recipe) {
        StringBuilder builder = new StringBuilder();
        if (recipe.hasFluidToChemical()) {
            builder.append(CrTUtils.describeOutputs(recipe.getChemicalOutputDefinition())).append(" for fluid to chemical");
        }
        if (recipe.hasChemicalToFluid()) {
            if (recipe.hasFluidToChemical()) {
                builder.append(" and ");
            }
            builder.append(CrTUtils.describeOutputs(recipe.getFluidOutputDefinition(), IFluidStack::of)).append(" for chemical to fluid");
        }
        return builder.toString();
    }
}

