/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.lookingat.wthit;

import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.ICommonAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.data.EnergyData;
import mcp.mobius.waila.api.data.FluidData;
import mekanism.common.Mekanism;
import mekanism.common.block.BlockBounding;
import mekanism.common.entity.EntityRobit;
import mekanism.common.integration.lookingat.LookingAtUtils;
import mekanism.common.integration.lookingat.wthit.WTHITDataProvider;
import mekanism.common.integration.lookingat.wthit.WTHITEntityDataProvider;
import mekanism.common.integration.lookingat.wthit.WTHITLookingAtHelper;
import mekanism.common.integration.lookingat.wthit.WTHITTooltipRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class MekanismWTHITPlugin
implements IWailaPlugin {
    static final ResourceLocation MEK_DATA = Mekanism.rl("wthit_data");

    public void register(IRegistrar registration) {
        registration.addBlockData((IDataProvider)WTHITDataProvider.INSTANCE, BlockEntity.class);
        registration.addEntityData((IDataProvider)WTHITEntityDataProvider.INSTANCE, EntityRobit.class);
        registration.addConfig(LookingAtUtils.ENERGY, true);
        registration.addConfig(LookingAtUtils.FLUID, true);
        registration.addConfig(LookingAtUtils.CHEMICAL, true);
        registration.addComponent((IEntityComponentProvider)WTHITTooltipRenderer.INSTANCE, TooltipPosition.BODY, EntityRobit.class);
        registration.addComponent((IBlockComponentProvider)WTHITTooltipRenderer.INSTANCE, TooltipPosition.BODY, Block.class);
        registration.addDataType(WTHITLookingAtHelper.TYPE, WTHITLookingAtHelper.STREAM_CODEC);
        registration.addEventListener(new IEventListener(this){

            public void onHandleTooltip(ITooltip tooltip, ICommonAccessor accessor, IPluginConfig config) {
                if (tooltip.getLine(MEK_DATA) != null) {
                    if (tooltip.getLine(EnergyData.ID) != null) {
                        tooltip.setLine(EnergyData.ID);
                    }
                    if (tooltip.getLine(FluidData.ID) != null) {
                        tooltip.setLine(FluidData.ID);
                    }
                }
            }
        });
        registration.addOverride(new IBlockComponentProvider(this){

            @Nullable
            public BlockState getOverride(IBlockAccessor accessor, IPluginConfig config) {
                Level level;
                BlockPos mainPos;
                BlockHitResult result = accessor.getBlockHitResult();
                if (result.getType() != HitResult.Type.MISS && (mainPos = BlockBounding.getMainBlockPos((BlockGetter)(level = accessor.getWorld()), result.getBlockPos())) != null) {
                    return level.getBlockState(mainPos);
                }
                return null;
            }
        }, BlockBounding.class);
    }
}

