/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import moze_intel.projecte.api.nss.AbstractNSSTag;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;

public final class NSSChemical
extends AbstractNSSTag<Chemical> {
    public static final MapCodec<NSSChemical> CODEC = NSSChemical.createCodec(MekanismAPI.CHEMICAL_REGISTRY, (boolean)false, NSSChemical::new);

    private NSSChemical(@NotNull ResourceLocation resourceLocation, boolean isTag) {
        super(resourceLocation, isTag);
    }

    @NotNull
    public static NSSChemical createChemical(@NotNull ChemicalStack stack) {
        return NSSChemical.createChemical(stack.getChemicalHolder());
    }

    @NotNull
    public static NSSChemical createChemical(@NotNull Holder<Chemical> chemical) {
        ResourceKey key = chemical.getKey();
        if (key == null) {
            if (!chemical.isBound()) {
                throw new IllegalArgumentException("Can't make an NSSChemical with an unbound direct holder");
            }
            Optional registryKey = MekanismAPI.CHEMICAL_REGISTRY.getResourceKey((Object)((Chemical)chemical.value()));
            if (registryKey.isEmpty()) {
                throw new IllegalArgumentException("Can't make an NSSChemical with an unregistered chemical");
            }
            key = (ResourceKey)registryKey.get();
        }
        return NSSChemical.createChemical(key.location());
    }

    @NotNull
    public static NSSChemical createChemical(@NotNull ResourceLocation chemicalId) {
        if (chemicalId.equals((Object)MekanismAPI.CHEMICAL_REGISTRY.getDefaultKey())) {
            throw new IllegalArgumentException("Can't make NSSChemical with an empty chemical");
        }
        return new NSSChemical(chemicalId, false);
    }

    @NotNull
    public static NSSChemical createTag(@NotNull ResourceLocation tagId) {
        return new NSSChemical(tagId, true);
    }

    @NotNull
    public static NSSChemical createTag(@NotNull TagKey<Chemical> tag) {
        return NSSChemical.createTag(tag.location());
    }

    @NotNull
    protected Registry<Chemical> getRegistry() {
        return MekanismAPI.CHEMICAL_REGISTRY;
    }

    protected NormalizedSimpleStack createNew(Holder<Chemical> chemical) {
        return NSSChemical.createChemical(chemical);
    }

    public MapCodec<? extends NormalizedSimpleStack> codec() {
        return CODEC;
    }
}

