/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.block;

import java.util.EnumMap;
import java.util.List;
import java.util.function.Consumer;
import mekanism.api.RelativeSide;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.component.AttachedEjector;
import mekanism.common.attachments.component.AttachedSideConfig;
import mekanism.common.attachments.containers.energy.ComponentBackedEnergyCubeContainer;
import mekanism.common.attachments.containers.energy.EnergyContainersBuilder;
import mekanism.common.block.BlockEnergyCube;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.block.ItemBlockTooltip;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.registration.impl.CreativeTabDeferredRegister;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tier.EnergyCubeTier;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.text.EnergyDisplay;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class ItemBlockEnergyCube
extends ItemBlockTooltip<BlockEnergyCube>
implements CreativeTabDeferredRegister.ICustomCreativeTabContents {
    public static final AttachedSideConfig SIDE_CONFIG = ItemBlockEnergyCube.sideConfig(AttachedSideConfig.LightConfigInfo.FRONT_OUT_EJECT);
    public static final AttachedSideConfig ALL_INPUT = (AttachedSideConfig)Util.make(() -> {
        EnumMap<RelativeSide, DataType> sideData = new EnumMap<RelativeSide, DataType>(RelativeSide.class);
        for (RelativeSide side : EnumUtils.SIDES) {
            sideData.put(side, DataType.INPUT);
        }
        return ItemBlockEnergyCube.sideConfig(new AttachedSideConfig.LightConfigInfo(sideData, false));
    });
    public static final AttachedSideConfig ALL_OUTPUT = (AttachedSideConfig)Util.make(() -> {
        EnumMap<RelativeSide, DataType> sideData = new EnumMap<RelativeSide, DataType>(RelativeSide.class);
        for (RelativeSide side : EnumUtils.SIDES) {
            sideData.put(side, DataType.OUTPUT);
        }
        return ItemBlockEnergyCube.sideConfig(new AttachedSideConfig.LightConfigInfo(sideData, true));
    });

    private static AttachedSideConfig sideConfig(AttachedSideConfig.LightConfigInfo energyConfig) {
        EnumMap<TransmissionType, AttachedSideConfig.LightConfigInfo> configInfo = new EnumMap<TransmissionType, AttachedSideConfig.LightConfigInfo>(TransmissionType.class);
        configInfo.put(TransmissionType.ITEM, AttachedSideConfig.LightConfigInfo.FRONT_OUT_NO_EJECT);
        configInfo.put(TransmissionType.ENERGY, energyConfig);
        return new AttachedSideConfig(configInfo);
    }

    public ItemBlockEnergyCube(BlockEnergyCube block, Item.Properties properties) {
        super(block, true, properties.component(MekanismDataComponents.EJECTOR, (Object)AttachedEjector.DEFAULT).component(MekanismDataComponents.SIDE_CONFIG, (Object)SIDE_CONFIG));
    }

    @Override
    @NotNull
    public EnergyCubeTier getTier() {
        return Attribute.getTier(this.getBlock(), EnergyCubeTier.class);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        StorageUtils.addStoredEnergy(stack, tooltip, true);
        tooltip.add((Component)MekanismLang.CAPACITY.translateColored(EnumColor.INDIGO, EnumColor.GRAY, EnergyDisplay.of(this.getTier().getMaxEnergy())));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    @Override
    protected void addTypeDetails(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return stack.getCount() == 1;
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        return StorageUtils.getEnergyBarWidth(stack);
    }

    public int getBarColor(@NotNull ItemStack stack) {
        return MekanismConfig.client.energyColor.get();
    }

    @Override
    public void addItems(Holder<Item> item, Consumer<ItemStack> tabOutput) {
        EnergyCubeTier tier = this.getTier();
        if (tier == EnergyCubeTier.CREATIVE) {
            tabOutput.accept(ItemBlockEnergyCube.withCreativeSideConfig(ALL_INPUT));
            tabOutput.accept(StorageUtils.getFilledEnergyVariant(ItemBlockEnergyCube.withCreativeSideConfig(ALL_OUTPUT)));
        } else {
            tabOutput.accept(StorageUtils.getFilledEnergyVariant(item));
        }
    }

    @Override
    public boolean addDefault() {
        return this.getTier() != EnergyCubeTier.CREATIVE;
    }

    public static ItemStack withCreativeSideConfig(AttachedSideConfig config) {
        ItemStack stack = new ItemStack(MekanismBlocks.CREATIVE_ENERGY_CUBE);
        stack.set(MekanismDataComponents.SIDE_CONFIG, (Object)config);
        return stack;
    }

    @Override
    protected EnergyContainersBuilder addDefaultEnergyContainers(EnergyContainersBuilder builder) {
        return builder.addContainer(ComponentBackedEnergyCubeContainer::create);
    }
}

