/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib;

import it.unimi.dsi.fastutil.longs.LongList;
import mekanism.common.content.transporter.TransporterPathfinder;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import org.jetbrains.annotations.Nullable;

public record SidedBlockPos(long pos, Direction side) {
    public static SidedBlockPos get(TransporterPathfinder.Destination destination) {
        LongList path = destination.getPath();
        long pos = path.getLong(0);
        Direction sideOfDest = WorldUtils.sideDifference(path.getLong(1), pos);
        return new SidedBlockPos(pos, sideOfDest);
    }

    @Nullable
    public static SidedBlockPos deserialize(CompoundTag tag) {
        if (tag.contains("side", 3)) {
            long pos = Long.MAX_VALUE;
            if (tag.contains("position", 11)) {
                pos = NbtUtils.readBlockPos((CompoundTag)tag, (String)"position").map(BlockPos::asLong).orElse(Long.MAX_VALUE);
            } else if (tag.contains("position", 4)) {
                pos = tag.getLong("position");
            }
            if (pos != Long.MAX_VALUE) {
                return new SidedBlockPos(pos, Direction.from3DDataValue((int)tag.getInt("side")));
            }
        }
        return null;
    }

    public CompoundTag serialize() {
        CompoundTag target = new CompoundTag();
        target.putLong("position", this.pos);
        NBTUtils.writeEnum(target, "side", this.side);
        return target;
    }
}

