/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.math;

import mekanism.common.lib.math.Quaternion;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Pos3D
extends Vec3 {
    public Pos3D() {
        this(0.0, 0.0, 0.0);
    }

    public Pos3D(Vec3 vec) {
        super(vec.x, vec.y, vec.z);
    }

    public Pos3D(double x, double y, double z) {
        super(x, y, z);
    }

    public Pos3D(Entity entity) {
        this(entity.getX(), entity.getY(), entity.getZ());
    }

    public static Pos3D create(BlockEntity tile) {
        return Pos3D.create((Vec3i)tile.getBlockPos());
    }

    public static Pos3D create(GlobalPos pos) {
        return Pos3D.create((Vec3i)pos.pos());
    }

    public static Pos3D create(Vec3i vec) {
        return new Pos3D(Pos3D.atLowerCornerOf((Vec3i)vec));
    }

    public static Pos3D translateMatrix(double[] matrix, Pos3D translation) {
        double x = translation.x * matrix[0] + translation.y * matrix[1] + translation.z * matrix[2] + matrix[3];
        double y = translation.x * matrix[4] + translation.y * matrix[5] + translation.z * matrix[6] + matrix[7];
        double z = translation.x * matrix[8] + translation.y * matrix[9] + translation.z * matrix[10] + matrix[11];
        return new Pos3D(x, y, z);
    }

    public static double[] getRotationMatrix(float angle, Pos3D axis) {
        return axis.getRotationMatrix(angle);
    }

    public static double anglePreNorm(Pos3D pos1, Pos3D pos2) {
        return Math.acos(pos1.dot(pos2));
    }

    public static AABB getAABB(Vec3 pos1, Vec3 pos2) {
        return new AABB(pos1.x, pos1.y, pos1.z, pos2.x, pos2.y, pos2.z);
    }

    public Pos3D diff(Vec3 vec) {
        return new Pos3D(this.x - vec.x, this.y - vec.y, this.z - vec.z);
    }

    public GlobalPos getGlobalPos(ResourceKey<Level> dimension) {
        return GlobalPos.of(dimension, (BlockPos)BlockPos.containing((double)this.x, (double)this.y, (double)this.z));
    }

    public Pos3D centre() {
        return this.translate(0.5, 0.5, 0.5);
    }

    public Pos3D translate(double x, double y, double z) {
        return new Pos3D(this.x + x, this.y + y, this.z + z);
    }

    public Pos3D translate(Vec3 pos) {
        return this.translate(pos.x, pos.y, pos.z);
    }

    public Pos3D translate(Vec3 ... positions) {
        double x = this.x;
        double y = this.y;
        double z = this.z;
        for (Vec3 position : positions) {
            x += position.x;
            y += position.y;
            z += position.z;
        }
        return new Pos3D(x, y, z);
    }

    public Pos3D translate(Direction direction, double amount) {
        return this.translate((double)direction.getNormal().getX() * amount, (double)direction.getNormal().getY() * amount, (double)direction.getNormal().getZ() * amount);
    }

    public Pos3D translateExcludingSide(Direction direction, double amount) {
        double xPos = this.x;
        double yPos = this.y;
        double zPos = this.z;
        if (direction.getAxis() != Direction.Axis.X) {
            xPos += amount;
        }
        if (direction.getAxis() != Direction.Axis.Y) {
            yPos += amount;
        }
        if (direction.getAxis() != Direction.Axis.Z) {
            zPos += amount;
        }
        return new Pos3D(xPos, yPos, zPos);
    }

    public Pos3D adjustPosition(Direction direction, Entity entity) {
        if (direction.getAxis() == Direction.Axis.X) {
            return new Pos3D(entity.getX(), this.y, this.z);
        }
        if (direction.getAxis() == Direction.Axis.Y) {
            return new Pos3D(this.x, entity.getY(), this.z);
        }
        return new Pos3D(this.x, this.y, entity.getZ());
    }

    public double distance(Vec3 pos) {
        return Mth.length((double)(this.x - pos.x), (double)(this.y - pos.y), (double)(this.z - pos.z));
    }

    @NotNull
    public Pos3D yRot(float yaw) {
        double yawRadians = Math.toRadians(yaw);
        double xPos = this.x;
        double zPos = this.z;
        if (yaw != 0.0f) {
            double cos = Math.cos(yawRadians);
            double sin = Math.sin(yawRadians);
            xPos = this.x * cos - this.z * sin;
            zPos = this.z * cos + this.x * sin;
        }
        return new Pos3D(xPos, this.y, zPos);
    }

    @NotNull
    public Pos3D xRot(float pitch) {
        double pitchRadians = Math.toRadians(pitch);
        double yPos = this.y;
        double zPos = this.z;
        if (pitch != 0.0f) {
            double cos = Math.cos(pitchRadians);
            double sin = Math.sin(pitchRadians);
            yPos = this.y * cos - this.z * sin;
            zPos = this.z * cos + this.y * sin;
        }
        return new Pos3D(this.x, yPos, zPos);
    }

    public Pos3D rotate(float yaw, float pitch) {
        return this.rotate(yaw, pitch, 0.0f);
    }

    public Pos3D rotate(float yaw, float pitch, float roll) {
        double yawRadians = Math.toRadians(yaw);
        double pitchRadians = Math.toRadians(pitch);
        double rollRadians = Math.toRadians(roll);
        double xPos = this.x * Math.cos(yawRadians) * Math.cos(pitchRadians) + this.z * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) - Math.sin(yawRadians) * Math.cos(rollRadians)) + this.y * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) + Math.sin(yawRadians) * Math.sin(rollRadians));
        double zPos = this.x * Math.sin(yawRadians) * Math.cos(pitchRadians) + this.z * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) + Math.cos(yawRadians) * Math.cos(rollRadians)) + this.y * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) - Math.cos(yawRadians) * Math.sin(rollRadians));
        double yPos = -this.x * Math.sin(pitchRadians) + this.z * Math.cos(pitchRadians) * Math.sin(rollRadians) + this.y * Math.cos(pitchRadians) * Math.cos(rollRadians);
        return new Pos3D(xPos, yPos, zPos);
    }

    @NotNull
    public Pos3D multiply(Vec3 pos) {
        return this.multiply(pos.x, pos.y, pos.z);
    }

    @NotNull
    public Pos3D multiply(double x, double y, double z) {
        return new Pos3D(this.x * x, this.y * y, this.z * z);
    }

    @NotNull
    public Pos3D scale(double scale) {
        return this.multiply(scale, scale, scale);
    }

    public Pos3D rotate(float angle, Pos3D axis) {
        return Pos3D.translateMatrix(Pos3D.getRotationMatrix(angle, axis), this);
    }

    public Pos3D transform(Quaternion quaternion) {
        Quaternion q = quaternion.copy();
        q.multiply(new Quaternion(this.x, this.y, this.z, 0.0));
        q.multiply(quaternion.copy().conjugate());
        return new Pos3D(q.getX(), q.getY(), q.getZ());
    }

    public double[] getRotationMatrix(float angle) {
        double[] matrix = new double[16];
        Pos3D axis = this.normalize();
        double x = axis.x;
        double y = axis.y;
        double z = axis.z;
        double angleAsRadian = Math.toRadians(angle);
        float cos = (float)Math.cos(angleAsRadian);
        float ocos = 1.0f - cos;
        float sin = (float)Math.sin(angleAsRadian);
        matrix[0] = x * x * (double)ocos + (double)cos;
        matrix[1] = y * x * (double)ocos + z * (double)sin;
        matrix[2] = x * z * (double)ocos - y * (double)sin;
        matrix[4] = x * y * (double)ocos - z * (double)sin;
        matrix[5] = y * y * (double)ocos + (double)cos;
        matrix[6] = y * z * (double)ocos + x * (double)sin;
        matrix[8] = x * z * (double)ocos + y * (double)sin;
        matrix[9] = y * z * (double)ocos - x * (double)sin;
        matrix[10] = z * z * (double)ocos + (double)cos;
        matrix[15] = 1.0;
        return matrix;
    }

    public double anglePreNorm(Pos3D pos2) {
        return Math.acos(this.dot(pos2));
    }

    @NotNull
    public Pos3D normalize() {
        return new Pos3D(super.normalize());
    }

    public Pos3D xCrossProduct() {
        return new Pos3D(0.0, this.z, -this.y);
    }

    public Pos3D zCrossProduct() {
        return new Pos3D(-this.y, this.x, 0.0);
    }

    public Pos3D getPerpendicular() {
        return this.z == 0.0 ? this.zCrossProduct() : this.xCrossProduct();
    }

    public Pos3D floor() {
        return new Pos3D(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
    }

    public Pos3D clone() {
        return new Pos3D(this.x, this.y, this.z);
    }

    @NotNull
    public String toString() {
        return "[Pos3D: " + this.x + ", " + this.y + ", " + this.z + "]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof Vec3)) return false;
        Vec3 other = (Vec3)obj;
        if (other.x != this.x) return false;
        if (other.y != this.y) return false;
        if (other.z != this.z) return false;
        return true;
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + Double.hashCode(this.x);
        code = 31 * code + Double.hashCode(this.y);
        code = 31 * code + Double.hashCode(this.z);
        return code;
    }
}

