/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registration.impl;

import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalBuilder;
import mekanism.common.base.IChemicalConstant;
import mekanism.common.registration.MekanismDeferredRegister;
import mekanism.common.registration.impl.DeferredChemical;
import mekanism.common.registration.impl.SlurryRegistryObject;
import mekanism.common.resource.PrimaryResource;
import mekanism.common.util.ChemicalUtil;
import net.minecraft.resources.ResourceLocation;

@NothingNullByDefault
public class ChemicalDeferredRegister
extends MekanismDeferredRegister<Chemical> {
    public ChemicalDeferredRegister(String modid) {
        super(MekanismAPI.CHEMICAL_REGISTRY_NAME, modid, DeferredChemical::new);
    }

    public DeferredChemical<Chemical> register(IChemicalConstant constants) {
        return this.register(constants.getName(), constants.getColor());
    }

    public DeferredChemical<Chemical> register(String name, int color) {
        return this.register(name, () -> new Chemical(ChemicalBuilder.builder().tint(color)));
    }

    public DeferredChemical<Chemical> registerPigment(String name, int color) {
        return this.register(name, () -> new Chemical(ChemicalBuilder.pigment().tint(color)));
    }

    public DeferredChemical<Chemical> registerInfuse(String name, int tint) {
        return this.register(name, () -> new Chemical(ChemicalBuilder.infuseType().tint(tint)));
    }

    public DeferredChemical<Chemical> register(String name, ResourceLocation texture, int barColor) {
        return this.register(name, () -> ChemicalUtil.chemical(ChemicalBuilder.builder(texture), barColor));
    }

    public <CHEM extends Chemical> DeferredChemical<CHEM> register(String name, Supplier<? extends CHEM> sup) {
        return (DeferredChemical)super.register(name, sup);
    }

    public SlurryRegistryObject<Chemical, Chemical> registerSlurry(PrimaryResource resource) {
        return this.registerSlurry(resource.getRegistrySuffix(), builder -> builder.tint(resource.getTint()));
    }

    public SlurryRegistryObject<Chemical, Chemical> registerSlurry(String baseName, UnaryOperator<ChemicalBuilder> builderModifier) {
        return new SlurryRegistryObject<Chemical, Chemical>((DeferredChemical<Chemical>)this.register("dirty_" + baseName, () -> new Chemical((ChemicalBuilder)builderModifier.apply(ChemicalBuilder.dirtySlurry()))), (DeferredChemical<Chemical>)this.register("clean_" + baseName, () -> new Chemical((ChemicalBuilder)builderModifier.apply(ChemicalBuilder.cleanSlurry()))));
    }
}

