/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.value.CachedValue;
import mekanism.common.content.filter.FilterManager;
import mekanism.common.content.oredictionificator.OredictionificatorFilter;
import mekanism.common.content.oredictionificator.OredictionificatorItemFilter;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.IRedstoneControl;
import mekanism.common.tile.interfaces.ITileFilterHolder;
import mekanism.common.tile.prefab.TileEntityConfigurableMachine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntityOredictionificator
extends TileEntityConfigurableMachine
implements ITileFilterHolder<OredictionificatorItemFilter> {
    private final FilterManager<OredictionificatorItemFilter> filterManager = new FilterManager<OredictionificatorItemFilter>(OredictionificatorItemFilter.class, this::markForSave);
    public boolean didProcess;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"}, docPlaceholder="input slot")
    InputInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"}, docPlaceholder="output slot")
    OutputInventorySlot outputSlot;
    private final CachedValue.IConfigValueInvalidationListener validFiltersListener = new ODConfigValueInvalidationListener();

    public TileEntityOredictionificator(BlockPos pos, BlockState state) {
        super((Holder<Block>)MekanismBlocks.OREDICTIONIFICATOR, pos, state);
        this.configComponent.setupIOConfig(TransmissionType.ITEM, (Object)this.inputSlot, this.outputSlot, RelativeSide.RIGHT);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(this.configComponent, TransmissionType.ITEM);
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(this);
        this.inputSlot = InputInventorySlot.at(item -> TileEntityOredictionificator.hasResult(this.filterManager.getEnabledFilters(), item), this::hasFilterableTags, listener, 56, 115);
        builder.addSlot(this.inputSlot);
        this.outputSlot = OutputInventorySlot.at(listener, 164, 115);
        builder.addSlot(this.outputSlot);
        return builder.build();
    }

    @Override
    protected boolean onUpdateServer() {
        ItemStack result;
        boolean sendUpdatePacket = super.onUpdateServer();
        if (CommonWorldTickHandler.flushTagAndRecipeCaches) {
            for (OredictionificatorFilter oredictionificatorFilter : this.filterManager.getFilters()) {
                oredictionificatorFilter.flushCachedTag();
            }
        }
        this.didProcess = false;
        if (this.canFunction() && !this.inputSlot.isEmpty() && !(result = TileEntityOredictionificator.getResult(this.filterManager.getEnabledFilters(), this.inputSlot.getStack())).isEmpty()) {
            ItemStack itemStack = this.outputSlot.getStack();
            if (itemStack.isEmpty()) {
                this.inputSlot.shrinkStack(1, Action.EXECUTE);
                this.outputSlot.setStack(result);
                this.didProcess = true;
            } else if (ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)result) && itemStack.getCount() < this.outputSlot.getLimit(itemStack)) {
                this.inputSlot.shrinkStack(1, Action.EXECUTE);
                this.outputSlot.growStack(1, Action.EXECUTE);
                this.didProcess = true;
            }
        }
        return sendUpdatePacket;
    }

    public void onLoad() {
        super.onLoad();
        MekanismConfig.general.validOredictionificatorFilters.addInvalidationListener(this.validFiltersListener);
    }

    @Override
    public void setRemoved() {
        super.setRemoved();
        MekanismConfig.general.validOredictionificatorFilters.removeInvalidationListener(this.validFiltersListener);
    }

    private static List<ResourceLocation> getFilterableTags(ItemStack stack) {
        return stack.getTags().map(TagKey::location).filter(TileEntityOredictionificator::isPossibleFilter).toList();
    }

    private boolean hasFilterableTags(ItemStack stack) {
        return stack.getTags().anyMatch(tag -> TileEntityOredictionificator.isPossibleFilter(tag.location()));
    }

    private static boolean isPossibleFilter(ResourceLocation resource) {
        Map possibleFilters = (Map)MekanismConfig.general.validOredictionificatorFilters.get();
        for (String pre : possibleFilters.getOrDefault(resource.getNamespace(), Collections.emptyList())) {
            if (!resource.getPath().startsWith(pre)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidTarget(ResourceLocation tag) {
        if (BuiltInRegistries.ITEM.getTag(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tag)).isPresent()) {
            for (String filter : ((Map)MekanismConfig.general.validOredictionificatorFilters.get()).getOrDefault(tag.getNamespace(), Collections.emptyList())) {
                if (!tag.getPath().startsWith(filter)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasResult(List<OredictionificatorItemFilter> enabledFilters, ItemStack stack) {
        return !TileEntityOredictionificator.getResult(enabledFilters, stack).isEmpty();
    }

    private static ItemStack getResult(List<OredictionificatorItemFilter> enabledFilters, ItemStack stack) {
        if (!enabledFilters.isEmpty()) {
            for (ResourceLocation filterableTag : TileEntityOredictionificator.getFilterableTags(stack)) {
                for (OredictionificatorItemFilter filter : enabledFilters) {
                    ItemStack result;
                    if (!filter.filterMatches(filterableTag) || (result = (ItemStack)filter.getResult()).isEmpty()) continue;
                    return result;
                }
            }
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void writeSustainedData(HolderLookup.Provider provider, CompoundTag dataMap) {
        super.writeSustainedData(provider, dataMap);
        this.filterManager.writeToNBT(provider, dataMap);
    }

    @Override
    public void readSustainedData(HolderLookup.Provider provider, @NotNull CompoundTag dataMap) {
        super.readSustainedData(provider, dataMap);
        this.filterManager.readFromNBT(provider, dataMap);
    }

    @Override
    public boolean supportsMode(IRedstoneControl.RedstoneControl mode) {
        return true;
    }

    @Override
    public FilterManager<OredictionificatorItemFilter> getFilterManager() {
        return this.filterManager;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableBoolean.create(() -> this.didProcess, value -> {
            this.didProcess = value;
        }));
        this.filterManager.addContainerTrackers(container);
    }

    @ComputerMethod
    Collection<OredictionificatorItemFilter> getFilters() {
        return this.filterManager.getFilters();
    }

    @ComputerMethod(requiresPublicSecurity=true)
    boolean addFilter(OredictionificatorItemFilter filter) throws ComputerException {
        this.validateSecurityIsPublic();
        return this.filterManager.addFilter(filter);
    }

    @ComputerMethod(requiresPublicSecurity=true)
    boolean removeFilter(OredictionificatorItemFilter filter) throws ComputerException {
        this.validateSecurityIsPublic();
        return this.filterManager.removeFilter(filter);
    }

    public class ODConfigValueInvalidationListener
    implements CachedValue.IConfigValueInvalidationListener {
        @Override
        public void run() {
            for (OredictionificatorItemFilter filter : TileEntityOredictionificator.this.filterManager.getFilters()) {
                filter.checkValidity();
            }
        }

        public boolean isIn(Level level) {
            return TileEntityOredictionificator.this.getLevel() == level;
        }
    }
}

