/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.block;

import com.lunazstudios.cobblefurnies.block.entity.CabinetBlockEntity;
import com.lunazstudios.cobblefurnies.util.block.ShapeUtil;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CabinetBlock
extends BaseEntityBlock {
    public static final MapCodec<CabinetBlock> CODEC = CabinetBlock.simpleCodec(CabinetBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.DOOR_HINGE;
    protected static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0));
    protected static final VoxelShape SHAPE_EAST = ShapeUtil.rotateShape(SHAPE_NORTH, Direction.EAST);
    protected static final VoxelShape SHAPE_SOUTH = ShapeUtil.rotateShape(SHAPE_NORTH, Direction.SOUTH);
    protected static final VoxelShape SHAPE_WEST = ShapeUtil.rotateShape(SHAPE_NORTH, Direction.WEST);
    protected static final VoxelShape SHAPE_OPEN_LEFT_NORTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)14.0, (double)0.0, (double)-14.0, (double)16.0, (double)16.0, (double)2.0));
    protected static final VoxelShape SHAPE_OPEN_LEFT_EAST = ShapeUtil.rotateShape(SHAPE_OPEN_LEFT_NORTH, Direction.EAST);
    protected static final VoxelShape SHAPE_OPEN_LEFT_SOUTH = ShapeUtil.rotateShape(SHAPE_OPEN_LEFT_NORTH, Direction.SOUTH);
    protected static final VoxelShape SHAPE_OPEN_LEFT_WEST = ShapeUtil.rotateShape(SHAPE_OPEN_LEFT_NORTH, Direction.WEST);
    protected static final VoxelShape SHAPE_OPEN_RIGHT_NORTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)-14.0, (double)2.0, (double)16.0, (double)2.0));
    protected static final VoxelShape SHAPE_OPEN_RIGHT_EAST = ShapeUtil.rotateShape(SHAPE_OPEN_RIGHT_NORTH, Direction.EAST);
    protected static final VoxelShape SHAPE_OPEN_RIGHT_SOUTH = ShapeUtil.rotateShape(SHAPE_OPEN_RIGHT_NORTH, Direction.SOUTH);
    protected static final VoxelShape SHAPE_OPEN_RIGHT_WEST = ShapeUtil.rotateShape(SHAPE_OPEN_RIGHT_NORTH, Direction.WEST);

    public MapCodec<CabinetBlock> codec() {
        return CODEC;
    }

    public CabinetBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CabinetBlockEntity) {
            CabinetBlockEntity cabinetBE = (CabinetBlockEntity)blockEntity;
            player.openMenu((MenuProvider)cabinetBE);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.is(newState.getBlock())) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof Container) {
            Containers.dropContents((Level)level, (BlockPos)pos, (Container)((Container)blockEntity));
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CabinetBlockEntity) {
            CabinetBlockEntity cabinetBE = (CabinetBlockEntity)blockEntity;
            cabinetBE.recheckOpen();
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CabinetBlockEntity(pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        boolean open = (Boolean)state.getValue((Property)OPEN);
        DoorHingeSide hinge = (DoorHingeSide)state.getValue(HINGE);
        if (!open) {
            switch (facing) {
                case EAST: {
                    return SHAPE_EAST;
                }
                case SOUTH: {
                    return SHAPE_SOUTH;
                }
                case WEST: {
                    return SHAPE_WEST;
                }
            }
            return SHAPE_NORTH;
        }
        if (hinge == DoorHingeSide.LEFT) {
            switch (facing) {
                case EAST: {
                    return SHAPE_OPEN_LEFT_EAST;
                }
                case SOUTH: {
                    return SHAPE_OPEN_LEFT_SOUTH;
                }
                case WEST: {
                    return SHAPE_OPEN_LEFT_WEST;
                }
            }
            return SHAPE_OPEN_LEFT_NORTH;
        }
        switch (facing) {
            case EAST: {
                return SHAPE_OPEN_RIGHT_EAST;
            }
            case SOUTH: {
                return SHAPE_OPEN_RIGHT_SOUTH;
            }
            case WEST: {
                return SHAPE_OPEN_RIGHT_WEST;
            }
        }
        return SHAPE_OPEN_RIGHT_NORTH;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean waterlogged = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        Direction facing = context.getHorizontalDirection().getOpposite();
        BlockPos pos = context.getClickedPos();
        Vec3 clickVec = context.getClickLocation().subtract(Vec3.atLowerCornerOf((Vec3i)pos));
        Direction right = facing.getClockWise();
        double side = right.getAxis().choose(clickVec.x, 0.0, clickVec.z);
        side = Math.abs((double)Math.min(right.getAxisDirection().getStep(), 0) + side);
        DoorHingeSide hinge = side > 0.5 ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT;
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue(HINGE, (Comparable)hinge);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, OPEN, HINGE});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        DoorHingeSide hinge = (DoorHingeSide)state.getValue(HINGE);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (facing.getAxis() != Direction.Axis.Z) break;
                facing = mirror.mirror(facing);
                hinge = hinge == DoorHingeSide.LEFT ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT;
                break;
            }
            case FRONT_BACK: {
                if (facing.getAxis() != Direction.Axis.X) break;
                facing = mirror.mirror(facing);
                hinge = hinge == DoorHingeSide.LEFT ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT;
            }
        }
        return (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)facing)).setValue(HINGE, (Comparable)hinge);
    }
}

