/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.block;

import com.lunazstudios.cobblefurnies.block.FreezerBlock;
import com.lunazstudios.cobblefurnies.block.entity.FridgeBlockEntity;
import com.lunazstudios.cobblefurnies.util.block.ShapeUtil;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FridgeBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    private final Block freezerBlock;
    protected static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)Block.box((double)13.0, (double)2.0, (double)-1.0, (double)14.0, (double)14.0, (double)0.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), Block.box((double)15.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)2.0, (double)1.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)1.0, (double)16.0), Block.box((double)1.0, (double)8.0, (double)2.0, (double)15.0, (double)8.0, (double)16.0), Block.box((double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0, (double)16.0), Block.box((double)1.0, (double)15.0, (double)2.0, (double)15.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape SHAPE_EAST = ShapeUtil.rotateShape(SHAPE_NORTH, Direction.EAST);
    protected static final VoxelShape SHAPE_SOUTH = ShapeUtil.rotateShape(SHAPE_NORTH, Direction.SOUTH);
    protected static final VoxelShape SHAPE_WEST = ShapeUtil.rotateShape(SHAPE_NORTH, Direction.WEST);
    protected static final VoxelShape SHAPE_OPEN_NORTH = Shapes.or((VoxelShape)Block.box((double)15.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)8.0, (double)2.0, (double)15.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)2.0, (double)1.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)1.0, (double)16.0), Block.box((double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0, (double)16.0), Block.box((double)1.0, (double)15.0, (double)2.0, (double)15.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape SHAPE_OPEN_EAST = ShapeUtil.rotateShape(SHAPE_OPEN_NORTH, Direction.EAST);
    protected static final VoxelShape SHAPE_OPEN_SOUTH = ShapeUtil.rotateShape(SHAPE_OPEN_NORTH, Direction.SOUTH);
    protected static final VoxelShape SHAPE_OPEN_WEST = ShapeUtil.rotateShape(SHAPE_OPEN_NORTH, Direction.WEST);

    public FridgeBlock(BlockBehaviour.Properties properties, Block freezerBlock) {
        super(properties);
        this.freezerBlock = freezerBlock;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockPos abovePos;
        super.onPlace(state, level, pos, oldState, isMoving);
        if (!level.isClientSide && this.freezerBlock != null && level.getBlockState(abovePos = pos.above()).isAir()) {
            BlockState freezerState = this.freezerBlock.defaultBlockState();
            if (freezerState.hasProperty((Property)FACING)) {
                freezerState = (BlockState)freezerState.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)));
            }
            level.setBlockAndUpdate(abovePos, freezerState);
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockPos freezerPos;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof Container) {
                Container container = (Container)blockEntity;
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)container);
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            if (level.getBlockState(freezerPos = pos.above()).getBlock() instanceof FreezerBlock) {
                level.removeBlock(freezerPos, false);
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FridgeBlockEntity) {
            FridgeBlockEntity BE = (FridgeBlockEntity)blockEntity;
            player.openMenu((MenuProvider)BE);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FridgeBlockEntity) {
            FridgeBlockEntity BE = (FridgeBlockEntity)blockEntity;
            BE.recheckOpen();
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FridgeBlockEntity(pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape voxelShape;
        Direction facing = (Direction)state.getValue((Property)FACING);
        boolean open = (Boolean)state.getValue((Property)OPEN);
        if (open) {
            switch (facing) {
                case EAST: {
                    voxelShape = SHAPE_OPEN_EAST;
                    break;
                }
                case SOUTH: {
                    voxelShape = SHAPE_OPEN_SOUTH;
                    break;
                }
                case WEST: {
                    voxelShape = SHAPE_OPEN_WEST;
                    break;
                }
                default: {
                    voxelShape = SHAPE_OPEN_NORTH;
                    break;
                }
            }
        } else {
            switch (facing) {
                case EAST: {
                    voxelShape = SHAPE_EAST;
                    break;
                }
                case SOUTH: {
                    voxelShape = SHAPE_SOUTH;
                    break;
                }
                case WEST: {
                    voxelShape = SHAPE_WEST;
                    break;
                }
                default: {
                    voxelShape = SHAPE_NORTH;
                }
            }
        }
        return voxelShape;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, OPEN});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockPos abovePos = pos.above();
        BlockState aboveState = world.getBlockState(abovePos);
        if (pos.getY() < world.getMaxBuildHeight() - 1 && aboveState.canBeReplaced(context)) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false));
        }
        return null;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return this.rotate(state, mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

