/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.block;

import com.lunazstudios.cobblefurnies.block.properties.CFBlockStateProperties;
import com.lunazstudios.cobblefurnies.registry.CFBlockTags;
import com.lunazstudios.cobblefurnies.util.block.ShapeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SinkBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty CONNECTED_LEFT = CFBlockStateProperties.CONNECTED_LEFT;
    public static final BooleanProperty CONNECTED_RIGHT = CFBlockStateProperties.CONNECTED_RIGHT;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape TOP_SHAPE_NORTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)12.0, (double)12.0, (double)14.0, (double)16.0, (double)12.0), Block.box((double)2.0, (double)12.0, (double)2.0, (double)14.0, (double)12.0, (double)12.0), Block.box((double)2.0, (double)12.0, (double)2.0, (double)14.0, (double)16.0, (double)2.0), Block.box((double)14.0, (double)12.0, (double)2.0, (double)14.0, (double)16.0, (double)12.0), Block.box((double)2.0, (double)12.0, (double)2.0, (double)2.0, (double)16.0, (double)12.0), Block.box((double)7.0, (double)16.0, (double)13.0, (double)9.0, (double)21.0, (double)15.0), Block.box((double)10.0, (double)16.0, (double)13.0, (double)12.0, (double)17.0, (double)15.0), Block.box((double)4.0, (double)16.0, (double)13.0, (double)6.0, (double)17.0, (double)15.0), Block.box((double)7.0, (double)19.0, (double)9.0, (double)9.0, (double)21.0, (double)13.0), Block.box((double)7.0, (double)18.0, (double)9.0, (double)9.0, (double)19.0, (double)11.0)});
    protected static final VoxelShape TOP_SHAPE_EAST = ShapeUtil.rotateShape(TOP_SHAPE_NORTH, Direction.EAST);
    protected static final VoxelShape TOP_SHAPE_SOUTH = ShapeUtil.rotateShape(TOP_SHAPE_NORTH, Direction.SOUTH);
    protected static final VoxelShape TOP_SHAPE_WEST = ShapeUtil.rotateShape(TOP_SHAPE_NORTH, Direction.WEST);
    protected static final VoxelShape BOTTOM_SELF_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0);
    protected static final VoxelShape BOTTOM_MIDDLE_SHAPE_NORTH = Block.box((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)11.0, (double)15.0);
    protected static final VoxelShape BOTTOM_MIDDLE_SHAPE_EAST = ShapeUtil.rotateShape(BOTTOM_MIDDLE_SHAPE_NORTH, Direction.EAST);
    protected static final VoxelShape BOTTOM_MIDDLE_SHAPE_SOUTH = ShapeUtil.rotateShape(BOTTOM_MIDDLE_SHAPE_NORTH, Direction.SOUTH);
    protected static final VoxelShape BOTTOM_MIDDLE_SHAPE_WEST = ShapeUtil.rotateShape(BOTTOM_MIDDLE_SHAPE_NORTH, Direction.WEST);
    protected static final VoxelShape BOTTOM_RIGHT_SHAPE_NORTH = Block.box((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)11.0, (double)15.0);
    protected static final VoxelShape BOTTOM_RIGHT_SHAPE_EAST = ShapeUtil.rotateShape(BOTTOM_RIGHT_SHAPE_NORTH, Direction.EAST);
    protected static final VoxelShape BOTTOM_RIGHT_SHAPE_SOUTH = ShapeUtil.rotateShape(BOTTOM_RIGHT_SHAPE_NORTH, Direction.SOUTH);
    protected static final VoxelShape BOTTOM_RIGHT_SHAPE_WEST = ShapeUtil.rotateShape(BOTTOM_RIGHT_SHAPE_NORTH, Direction.WEST);
    protected static final VoxelShape BOTTOM_LEFT_SHAPE_NORTH = Block.box((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0);
    protected static final VoxelShape BOTTOM_LEFT_SHAPE_EAST = ShapeUtil.rotateShape(BOTTOM_LEFT_SHAPE_NORTH, Direction.EAST);
    protected static final VoxelShape BOTTOM_LEFT_SHAPE_SOUTH = ShapeUtil.rotateShape(BOTTOM_LEFT_SHAPE_NORTH, Direction.SOUTH);
    protected static final VoxelShape BOTTOM_LEFT_SHAPE_WEST = ShapeUtil.rotateShape(BOTTOM_LEFT_SHAPE_NORTH, Direction.WEST);

    public SinkBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)CONNECTED_LEFT, (Comparable)Boolean.valueOf(false))).setValue((Property)CONNECTED_RIGHT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected boolean propagatesSkylightDown(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return blockState.getFluidState().isEmpty();
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        this.spawnWaterParticles(level, blockPos);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (itemStack.is(Items.BUCKET)) {
            if (!level.isClientSide) {
                ItemStack waterBucket = new ItemStack((ItemLike)Items.WATER_BUCKET);
                if (!player.getAbilities().instabuild) {
                    itemStack.shrink(1);
                    if (!player.getInventory().add(waterBucket)) {
                        player.drop(waterBucket, false);
                    }
                }
                level.playSound(null, blockPos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            this.spawnWaterParticles(level, blockPos);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        this.spawnWaterParticles(level, blockPos);
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    private void spawnWaterParticles(Level level, BlockPos pos) {
        if (level.isClientSide) {
            for (int i = 0; i < 5; ++i) {
                level.addParticle((ParticleOptions)ParticleTypes.SPLASH, (double)pos.getX() + 0.5 + (level.random.nextDouble() - 0.5) * 0.3, (double)pos.getY() + 1.1, (double)pos.getZ() + 0.5 + (level.random.nextDouble() - 0.5) * 0.3, 0.0, 0.05, 0.0);
            }
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape bottomShape;
        Direction facing = (Direction)state.getValue((Property)FACING);
        boolean connectedLeft = (Boolean)state.getValue((Property)CONNECTED_LEFT);
        boolean connectedRight = (Boolean)state.getValue((Property)CONNECTED_RIGHT);
        VoxelShape topShape = switch (facing) {
            case Direction.EAST -> TOP_SHAPE_EAST;
            case Direction.SOUTH -> TOP_SHAPE_SOUTH;
            case Direction.WEST -> TOP_SHAPE_WEST;
            default -> TOP_SHAPE_NORTH;
        };
        if (connectedLeft && connectedRight) {
            switch (facing) {
                case EAST: {
                    bottomShape = BOTTOM_MIDDLE_SHAPE_EAST;
                    break;
                }
                case SOUTH: {
                    bottomShape = BOTTOM_MIDDLE_SHAPE_SOUTH;
                    break;
                }
                case WEST: {
                    bottomShape = BOTTOM_MIDDLE_SHAPE_WEST;
                    break;
                }
                default: {
                    bottomShape = BOTTOM_MIDDLE_SHAPE_NORTH;
                    break;
                }
            }
        } else if (connectedLeft) {
            switch (facing) {
                case EAST: {
                    bottomShape = BOTTOM_LEFT_SHAPE_EAST;
                    break;
                }
                case SOUTH: {
                    bottomShape = BOTTOM_LEFT_SHAPE_SOUTH;
                    break;
                }
                case WEST: {
                    bottomShape = BOTTOM_LEFT_SHAPE_WEST;
                    break;
                }
                default: {
                    bottomShape = BOTTOM_LEFT_SHAPE_NORTH;
                    break;
                }
            }
        } else if (connectedRight) {
            switch (facing) {
                case EAST: {
                    bottomShape = BOTTOM_RIGHT_SHAPE_EAST;
                    break;
                }
                case SOUTH: {
                    bottomShape = BOTTOM_RIGHT_SHAPE_SOUTH;
                    break;
                }
                case WEST: {
                    bottomShape = BOTTOM_RIGHT_SHAPE_WEST;
                    break;
                }
                default: {
                    bottomShape = BOTTOM_RIGHT_SHAPE_NORTH;
                    break;
                }
            }
        } else {
            bottomShape = BOTTOM_SELF_SHAPE;
        }
        return Shapes.or((VoxelShape)topShape, (VoxelShape)bottomShape);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean waterlogged = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        Direction facing = context.getHorizontalDirection().getOpposite();
        return this.getConnections((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)), (LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return this.getConnections(state, level, currentPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, CONNECTED_LEFT, CONNECTED_RIGHT, WATERLOGGED});
    }

    private BlockState getConnections(BlockState state, @Nullable LevelAccessor level, @Nullable BlockPos pos) {
        if (level == null || pos == null) {
            return (BlockState)((BlockState)state.setValue((Property)CONNECTED_LEFT, (Comparable)Boolean.valueOf(false))).setValue((Property)CONNECTED_RIGHT, (Comparable)Boolean.valueOf(false));
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        boolean left = this.validConnection(level.getBlockState(pos.relative(facing.getCounterClockWise())));
        boolean right = this.validConnection(level.getBlockState(pos.relative(facing.getClockWise())));
        return (BlockState)((BlockState)state.setValue((Property)CONNECTED_LEFT, (Comparable)Boolean.valueOf(left))).setValue((Property)CONNECTED_RIGHT, (Comparable)Boolean.valueOf(right));
    }

    private boolean validConnection(BlockState state) {
        return state.is(CFBlockTags.SINKS_CONNECTABLE);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        Direction newFacing = rotation.rotate((Direction)state.getValue((Property)FACING));
        return this.getConnections((BlockState)state.setValue((Property)FACING, (Comparable)newFacing), null, null);
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return this.rotate(state, mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

