/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.block;

import com.lunazstudios.cobblefurnies.block.SeatBlock;
import com.lunazstudios.cobblefurnies.block.properties.CFBlockStateProperties;
import com.lunazstudios.cobblefurnies.block.properties.SofaType;
import com.lunazstudios.cobblefurnies.util.block.ShapeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SofaBlock
extends SeatBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<SofaType> TYPE = CFBlockStateProperties.SOFA_TYPE;
    protected static final VoxelShape SOFA_NORTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)7.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)13.0, (double)7.0, (double)0.0, (double)16.0, (double)11.0, (double)12.0), Block.box((double)0.0, (double)7.0, (double)0.0, (double)3.0, (double)11.0, (double)12.0), Block.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)3.0, (double)2.0), Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)2.0), Block.box((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)3.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)3.0, (double)16.0)});
    protected static final VoxelShape SOFA_EAST = ShapeUtil.rotateShape(SOFA_NORTH, Direction.EAST);
    protected static final VoxelShape SOFA_SOUTH = ShapeUtil.rotateShape(SOFA_NORTH, Direction.SOUTH);
    protected static final VoxelShape SOFA_WEST = ShapeUtil.rotateShape(SOFA_NORTH, Direction.WEST);
    protected static final VoxelShape SOFA_LEFT_NORTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)7.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)13.0, (double)7.0, (double)0.0, (double)16.0, (double)11.0, (double)12.0), Block.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)2.0), Block.box((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)3.0, (double)16.0)});
    protected static final VoxelShape SOFA_LEFT_EAST = ShapeUtil.rotateShape(SOFA_LEFT_NORTH, Direction.EAST);
    protected static final VoxelShape SOFA_LEFT_SOUTH = ShapeUtil.rotateShape(SOFA_LEFT_NORTH, Direction.SOUTH);
    protected static final VoxelShape SOFA_LEFT_WEST = ShapeUtil.rotateShape(SOFA_LEFT_NORTH, Direction.WEST);
    protected static final VoxelShape SOFA_MIDDLE_NORTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)7.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0));
    protected static final VoxelShape SOFA_MIDDLE_EAST = ShapeUtil.rotateShape(SOFA_MIDDLE_NORTH, Direction.EAST);
    protected static final VoxelShape SOFA_MIDDLE_SOUTH = ShapeUtil.rotateShape(SOFA_MIDDLE_NORTH, Direction.SOUTH);
    protected static final VoxelShape SOFA_MIDDLE_WEST = ShapeUtil.rotateShape(SOFA_MIDDLE_NORTH, Direction.WEST);
    protected static final VoxelShape SOFA_RIGHT_NORTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)7.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)7.0, (double)0.0, (double)3.0, (double)11.0, (double)12.0), Block.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)3.0, (double)2.0), Block.box((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)3.0, (double)16.0)});
    protected static final VoxelShape SOFA_RIGHT_EAST = ShapeUtil.rotateShape(SOFA_RIGHT_NORTH, Direction.EAST);
    protected static final VoxelShape SOFA_RIGHT_SOUTH = ShapeUtil.rotateShape(SOFA_RIGHT_NORTH, Direction.SOUTH);
    protected static final VoxelShape SOFA_RIGHT_WEST = ShapeUtil.rotateShape(SOFA_RIGHT_NORTH, Direction.WEST);
    protected static final VoxelShape SOFA_INNER_NORTH_LEFT = Shapes.or((VoxelShape)Block.box((double)0.0, (double)7.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)12.0, (double)7.0, (double)0.0, (double)16.0, (double)16.0, (double)12.0), Block.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)3.0, (double)2.0), Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)2.0), Block.box((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)3.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)3.0, (double)16.0)});
    protected static final VoxelShape SOFA_INNER_EAST_LEFT = ShapeUtil.rotateShape(SOFA_INNER_NORTH_LEFT, Direction.EAST);
    protected static final VoxelShape SOFA_INNER_SOUTH_LEFT = ShapeUtil.rotateShape(SOFA_INNER_NORTH_LEFT, Direction.SOUTH);
    protected static final VoxelShape SOFA_INNER_WEST_LEFT = ShapeUtil.rotateShape(SOFA_INNER_NORTH_LEFT, Direction.WEST);
    protected static final VoxelShape SOFA_OUTER_NORTH_LEFT = Shapes.or((VoxelShape)Block.box((double)12.0, (double)7.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)3.0, (double)2.0), Block.box((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)3.0, (double)16.0)});
    protected static final VoxelShape SOFA_OUTER_EAST_LEFT = ShapeUtil.rotateShape(SOFA_OUTER_NORTH_LEFT, Direction.EAST);
    protected static final VoxelShape SOFA_OUTER_SOUTH_LEFT = ShapeUtil.rotateShape(SOFA_OUTER_NORTH_LEFT, Direction.SOUTH);
    protected static final VoxelShape SOFA_OUTER_WEST_LEFT = ShapeUtil.rotateShape(SOFA_OUTER_NORTH_LEFT, Direction.WEST);
    protected static final VoxelShape SOFA_INNER_NORTH_RIGHT = Shapes.or((VoxelShape)Block.box((double)0.0, (double)7.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)7.0, (double)0.0, (double)4.0, (double)16.0, (double)12.0), Block.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)2.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)3.0, (double)2.0), Block.box((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)3.0, (double)16.0), Block.box((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)3.0, (double)16.0)});
    protected static final VoxelShape SOFA_INNER_EAST_RIGHT = ShapeUtil.rotateShape(SOFA_INNER_NORTH_RIGHT, Direction.EAST);
    protected static final VoxelShape SOFA_INNER_SOUTH_RIGHT = ShapeUtil.rotateShape(SOFA_INNER_NORTH_RIGHT, Direction.SOUTH);
    protected static final VoxelShape SOFA_INNER_WEST_RIGHT = ShapeUtil.rotateShape(SOFA_INNER_NORTH_RIGHT, Direction.WEST);
    protected static final VoxelShape SOFA_OUTER_NORTH_RIGHT = Shapes.or((VoxelShape)Block.box((double)0.0, (double)7.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)2.0), Block.box((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)3.0, (double)16.0)});
    protected static final VoxelShape SOFA_OUTER_EAST_RIGHT = ShapeUtil.rotateShape(SOFA_OUTER_NORTH_RIGHT, Direction.EAST);
    protected static final VoxelShape SOFA_OUTER_SOUTH_RIGHT = ShapeUtil.rotateShape(SOFA_OUTER_NORTH_RIGHT, Direction.SOUTH);
    protected static final VoxelShape SOFA_OUTER_WEST_RIGHT = ShapeUtil.rotateShape(SOFA_OUTER_NORTH_RIGHT, Direction.WEST);

    public SofaBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public float seatHeight(BlockState state) {
        return 0.35f;
    }

    @Override
    public BlockPos primaryDismountLocation(Level level, BlockState state, BlockPos pos) {
        Direction facingRelative;
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockState stateRelative = level.getBlockState(pos.relative(facing));
        if (stateRelative.getBlock() instanceof SofaBlock && facing != (facingRelative = (Direction)stateRelative.getValue((Property)FACING))) {
            return pos.relative(facing).relative(facingRelative);
        }
        return pos.relative(facing);
    }

    @Override
    public float setRiderRotation(BlockState state, Entity entity) {
        float corner = switch ((SofaType)((Object)state.getValue(TYPE))) {
            case SofaType.INNER_LEFT, SofaType.OUTER_LEFT -> -45.0f;
            case SofaType.INNER_RIGHT, SofaType.OUTER_RIGHT -> 45.0f;
            default -> 0.0f;
        };
        return ((Direction)state.getValue((Property)FACING)).toYRot() + corner;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockPos = context.getClickedPos();
        FluidState fluidState = context.getLevel().getFluidState(blockPos);
        BlockState blockState = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        return (BlockState)blockState.setValue(TYPE, (Comparable)((Object)SofaBlock.getConnection(blockState, context.getLevel(), blockPos)));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (direction.getAxis().isHorizontal() && level instanceof Level) {
            Level realLevel = (Level)level;
            return (BlockState)state.setValue(TYPE, (Comparable)((Object)SofaBlock.getConnection(state, realLevel, currentPos)));
        }
        return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        SofaType type = (SofaType)((Object)state.getValue(TYPE));
        return switch (type) {
            default -> throw new MatchException(null, null);
            case SofaType.SINGLE -> {
                switch (facing) {
                    case NORTH: {
                        yield SOFA_NORTH;
                    }
                    case EAST: {
                        yield SOFA_EAST;
                    }
                    case SOUTH: {
                        yield SOFA_SOUTH;
                    }
                    case WEST: {
                        yield SOFA_WEST;
                    }
                }
                yield SOFA_NORTH;
            }
            case SofaType.LEFT -> {
                switch (facing) {
                    case NORTH: {
                        yield SOFA_LEFT_NORTH;
                    }
                    case EAST: {
                        yield SOFA_LEFT_EAST;
                    }
                    case SOUTH: {
                        yield SOFA_LEFT_SOUTH;
                    }
                    case WEST: {
                        yield SOFA_LEFT_WEST;
                    }
                }
                yield SOFA_NORTH;
            }
            case SofaType.MIDDLE -> {
                switch (facing) {
                    case NORTH: {
                        yield SOFA_MIDDLE_NORTH;
                    }
                    case EAST: {
                        yield SOFA_MIDDLE_EAST;
                    }
                    case SOUTH: {
                        yield SOFA_MIDDLE_SOUTH;
                    }
                    case WEST: {
                        yield SOFA_MIDDLE_WEST;
                    }
                }
                yield SOFA_NORTH;
            }
            case SofaType.RIGHT -> {
                switch (facing) {
                    case NORTH: {
                        yield SOFA_RIGHT_NORTH;
                    }
                    case EAST: {
                        yield SOFA_RIGHT_EAST;
                    }
                    case SOUTH: {
                        yield SOFA_RIGHT_SOUTH;
                    }
                    case WEST: {
                        yield SOFA_RIGHT_WEST;
                    }
                }
                yield SOFA_NORTH;
            }
            case SofaType.INNER_LEFT -> {
                switch (facing) {
                    case NORTH: {
                        yield SOFA_INNER_NORTH_LEFT;
                    }
                    case EAST: {
                        yield SOFA_INNER_EAST_LEFT;
                    }
                    case SOUTH: {
                        yield SOFA_INNER_SOUTH_LEFT;
                    }
                    case WEST: {
                        yield SOFA_INNER_WEST_LEFT;
                    }
                }
                yield SOFA_NORTH;
            }
            case SofaType.INNER_RIGHT -> {
                switch (facing) {
                    case NORTH: {
                        yield SOFA_INNER_NORTH_RIGHT;
                    }
                    case EAST: {
                        yield SOFA_INNER_EAST_RIGHT;
                    }
                    case SOUTH: {
                        yield SOFA_INNER_SOUTH_RIGHT;
                    }
                    case WEST: {
                        yield SOFA_INNER_WEST_RIGHT;
                    }
                }
                yield SOFA_NORTH;
            }
            case SofaType.OUTER_LEFT -> {
                switch (facing) {
                    case NORTH: {
                        yield SOFA_OUTER_NORTH_LEFT;
                    }
                    case EAST: {
                        yield SOFA_OUTER_EAST_LEFT;
                    }
                    case SOUTH: {
                        yield SOFA_OUTER_SOUTH_LEFT;
                    }
                    case WEST: {
                        yield SOFA_OUTER_WEST_LEFT;
                    }
                }
                yield SOFA_NORTH;
            }
            case SofaType.OUTER_RIGHT -> {
                switch (facing) {
                    case NORTH: {
                        yield SOFA_OUTER_NORTH_RIGHT;
                    }
                    case EAST: {
                        yield SOFA_OUTER_EAST_RIGHT;
                    }
                    case SOUTH: {
                        yield SOFA_OUTER_SOUTH_RIGHT;
                    }
                    case WEST: {
                        yield SOFA_OUTER_WEST_RIGHT;
                    }
                }
                yield SOFA_NORTH;
            }
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, TYPE, WATERLOGGED});
    }

    public static SofaType getConnection(BlockState state, Level level, BlockPos pos) {
        Direction dir2;
        Direction dir1;
        if (level == null) {
            return SofaType.SINGLE;
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockState state1 = level.getBlockState(pos.relative(facing));
        if (state1.getBlock() instanceof SofaBlock && (dir1 = (Direction)state1.getValue((Property)FACING)).getAxis() != ((Direction)state.getValue((Property)FACING)).getAxis() && SofaBlock.isDifferentOrientation(state, level, pos, dir1.getOpposite())) {
            if (dir1 == facing.getCounterClockWise()) {
                return SofaType.INNER_LEFT;
            }
            return SofaType.INNER_RIGHT;
        }
        BlockState state2 = level.getBlockState(pos.relative(facing.getOpposite()));
        if (state2.getBlock() instanceof SofaBlock && (dir2 = (Direction)state2.getValue((Property)FACING)).getAxis() != ((Direction)state.getValue((Property)FACING)).getAxis() && SofaBlock.isDifferentOrientation(state, level, pos, dir2)) {
            if (dir2 == facing.getCounterClockWise()) {
                return SofaType.OUTER_LEFT;
            }
            return SofaType.OUTER_RIGHT;
        }
        boolean left = SofaBlock.canConnect(level, pos, ((Direction)state.getValue((Property)FACING)).getCounterClockWise());
        boolean right = SofaBlock.canConnect(level, pos, ((Direction)state.getValue((Property)FACING)).getClockWise());
        if (left && right) {
            return SofaType.MIDDLE;
        }
        if (left) {
            return SofaType.LEFT;
        }
        if (right) {
            return SofaType.RIGHT;
        }
        return SofaType.SINGLE;
    }

    public static boolean canConnect(Level level, BlockPos pos, Direction direction) {
        BlockState state = level.getBlockState(pos.relative(direction));
        return state.getBlock() instanceof SofaBlock;
    }

    public static boolean isDifferentOrientation(BlockState state, Level level, BlockPos pos, Direction dir) {
        BlockState blockState = level.getBlockState(pos.relative(dir));
        return !(blockState.getBlock() instanceof SofaBlock) || blockState.getValue((Property)FACING) != state.getValue((Property)FACING);
    }

    @Override
    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        Direction newFacing = rotation.rotate((Direction)state.getValue((Property)FACING));
        SofaType newType = SofaBlock.rotateType((SofaType)((Object)state.getValue(TYPE)), rotation);
        return (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)newFacing)).setValue(TYPE, (Comparable)((Object)newType));
    }

    private static SofaType rotateType(SofaType type, Rotation rotation) {
        return switch (type) {
            case SofaType.INNER_LEFT -> {
                if (rotation == Rotation.CLOCKWISE_90 || rotation == Rotation.COUNTERCLOCKWISE_90) {
                    yield SofaType.INNER_RIGHT;
                }
                yield type;
            }
            case SofaType.INNER_RIGHT -> {
                if (rotation == Rotation.CLOCKWISE_90 || rotation == Rotation.COUNTERCLOCKWISE_90) {
                    yield SofaType.INNER_LEFT;
                }
                yield type;
            }
            case SofaType.OUTER_LEFT -> {
                if (rotation == Rotation.CLOCKWISE_90 || rotation == Rotation.COUNTERCLOCKWISE_90) {
                    yield SofaType.OUTER_RIGHT;
                }
                yield type;
            }
            case SofaType.OUTER_RIGHT -> {
                if (rotation == Rotation.CLOCKWISE_90 || rotation == Rotation.COUNTERCLOCKWISE_90) {
                    yield SofaType.OUTER_LEFT;
                }
                yield type;
            }
            default -> type;
        };
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        SofaType type = (SofaType)((Object)state.getValue(TYPE));
        switch (mirror) {
            case LEFT_RIGHT: {
                if (direction.getAxis() != Direction.Axis.Z) break;
                return switch (type) {
                    case SofaType.INNER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(TYPE, (Comparable)((Object)SofaType.INNER_RIGHT));
                    case SofaType.INNER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(TYPE, (Comparable)((Object)SofaType.INNER_LEFT));
                    case SofaType.OUTER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(TYPE, (Comparable)((Object)SofaType.OUTER_RIGHT));
                    case SofaType.OUTER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(TYPE, (Comparable)((Object)SofaType.OUTER_LEFT));
                    default -> state.rotate(Rotation.CLOCKWISE_180);
                };
            }
            case FRONT_BACK: {
                if (direction.getAxis() != Direction.Axis.X) break;
                return switch (type) {
                    case SofaType.INNER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(TYPE, (Comparable)((Object)SofaType.INNER_LEFT));
                    case SofaType.INNER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(TYPE, (Comparable)((Object)SofaType.INNER_RIGHT));
                    case SofaType.OUTER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(TYPE, (Comparable)((Object)SofaType.OUTER_RIGHT));
                    case SofaType.OUTER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(TYPE, (Comparable)((Object)SofaType.OUTER_LEFT));
                    default -> state.rotate(Rotation.CLOCKWISE_180);
                };
            }
        }
        return super.mirror(state, mirror);
    }
}

