/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.block;

import com.lunazstudios.cobblefurnies.block.entity.StoveBlockEntity;
import com.lunazstudios.cobblefurnies.block.properties.CFBlockStateProperties;
import com.lunazstudios.cobblefurnies.registry.CFBlockTags;
import com.lunazstudios.cobblefurnies.util.block.ShapeUtil;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class StoveBlock
extends BaseEntityBlock {
    public static final MapCodec<StoveBlock> CODEC = StoveBlock.simpleCodec(StoveBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty CONNECTED_LEFT = CFBlockStateProperties.CONNECTED_LEFT;
    public static final BooleanProperty CONNECTED_RIGHT = CFBlockStateProperties.CONNECTED_RIGHT;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    protected static final VoxelShape TOP_SHAPE_NORTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)5.0, (double)16.0, (double)5.0, (double)11.0, (double)17.0, (double)11.0), Block.box((double)4.0, (double)16.5, (double)8.0, (double)12.0, (double)18.5, (double)8.0), Block.box((double)4.0, (double)16.5, (double)8.0, (double)12.0, (double)18.5, (double)8.0)});
    protected static final VoxelShape TOP_SHAPE_EAST = ShapeUtil.rotateShape(TOP_SHAPE_NORTH, Direction.EAST);
    protected static final VoxelShape TOP_SHAPE_SOUTH = ShapeUtil.rotateShape(TOP_SHAPE_NORTH, Direction.SOUTH);
    protected static final VoxelShape TOP_SHAPE_WEST = ShapeUtil.rotateShape(TOP_SHAPE_NORTH, Direction.WEST);
    protected static final VoxelShape BOTTOM_SELF_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0);
    protected static final VoxelShape BOTTOM_MIDDLE_SHAPE_NORTH = Block.box((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)11.0, (double)15.0);
    protected static final VoxelShape BOTTOM_MIDDLE_SHAPE_EAST = ShapeUtil.rotateShape(BOTTOM_MIDDLE_SHAPE_NORTH, Direction.EAST);
    protected static final VoxelShape BOTTOM_MIDDLE_SHAPE_SOUTH = ShapeUtil.rotateShape(BOTTOM_MIDDLE_SHAPE_NORTH, Direction.SOUTH);
    protected static final VoxelShape BOTTOM_MIDDLE_SHAPE_WEST = ShapeUtil.rotateShape(BOTTOM_MIDDLE_SHAPE_NORTH, Direction.WEST);
    protected static final VoxelShape BOTTOM_RIGHT_SHAPE_NORTH = Block.box((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)11.0, (double)15.0);
    protected static final VoxelShape BOTTOM_RIGHT_SHAPE_EAST = ShapeUtil.rotateShape(BOTTOM_RIGHT_SHAPE_NORTH, Direction.EAST);
    protected static final VoxelShape BOTTOM_RIGHT_SHAPE_SOUTH = ShapeUtil.rotateShape(BOTTOM_RIGHT_SHAPE_NORTH, Direction.SOUTH);
    protected static final VoxelShape BOTTOM_RIGHT_SHAPE_WEST = ShapeUtil.rotateShape(BOTTOM_RIGHT_SHAPE_NORTH, Direction.WEST);
    protected static final VoxelShape BOTTOM_LEFT_SHAPE_NORTH = Block.box((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0);
    protected static final VoxelShape BOTTOM_LEFT_SHAPE_EAST = ShapeUtil.rotateShape(BOTTOM_LEFT_SHAPE_NORTH, Direction.EAST);
    protected static final VoxelShape BOTTOM_LEFT_SHAPE_SOUTH = ShapeUtil.rotateShape(BOTTOM_LEFT_SHAPE_NORTH, Direction.SOUTH);
    protected static final VoxelShape BOTTOM_LEFT_SHAPE_WEST = ShapeUtil.rotateShape(BOTTOM_LEFT_SHAPE_NORTH, Direction.WEST);

    public MapCodec<StoveBlock> codec() {
        return CODEC;
    }

    public StoveBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)CONNECTED_LEFT, (Comparable)Boolean.valueOf(false))).setValue((Property)CONNECTED_RIGHT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof StoveBlockEntity) {
            StoveBlockEntity stoveBE = (StoveBlockEntity)blockEntity;
            player.openMenu((MenuProvider)stoveBE);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.is(newState.getBlock())) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof Container) {
            Containers.dropContents((Level)level, (BlockPos)pos, (Container)((Container)blockEntity));
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof StoveBlockEntity) {
            StoveBlockEntity stoveBE = (StoveBlockEntity)blockEntity;
            stoveBE.recheckOpen();
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new StoveBlockEntity(pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape bottomShape;
        Direction facing = (Direction)state.getValue((Property)FACING);
        boolean connectedLeft = (Boolean)state.getValue((Property)CONNECTED_LEFT);
        boolean connectedRight = (Boolean)state.getValue((Property)CONNECTED_RIGHT);
        VoxelShape topShape = switch (facing) {
            case Direction.EAST -> TOP_SHAPE_EAST;
            case Direction.SOUTH -> TOP_SHAPE_SOUTH;
            case Direction.WEST -> TOP_SHAPE_WEST;
            default -> TOP_SHAPE_NORTH;
        };
        if (connectedLeft && connectedRight) {
            switch (facing) {
                case EAST: {
                    bottomShape = BOTTOM_MIDDLE_SHAPE_EAST;
                    break;
                }
                case SOUTH: {
                    bottomShape = BOTTOM_MIDDLE_SHAPE_SOUTH;
                    break;
                }
                case WEST: {
                    bottomShape = BOTTOM_MIDDLE_SHAPE_WEST;
                    break;
                }
                default: {
                    bottomShape = BOTTOM_MIDDLE_SHAPE_NORTH;
                    break;
                }
            }
        } else if (connectedLeft) {
            switch (facing) {
                case EAST: {
                    bottomShape = BOTTOM_LEFT_SHAPE_EAST;
                    break;
                }
                case SOUTH: {
                    bottomShape = BOTTOM_LEFT_SHAPE_SOUTH;
                    break;
                }
                case WEST: {
                    bottomShape = BOTTOM_LEFT_SHAPE_WEST;
                    break;
                }
                default: {
                    bottomShape = BOTTOM_LEFT_SHAPE_NORTH;
                    break;
                }
            }
        } else if (connectedRight) {
            switch (facing) {
                case EAST: {
                    bottomShape = BOTTOM_RIGHT_SHAPE_EAST;
                    break;
                }
                case SOUTH: {
                    bottomShape = BOTTOM_RIGHT_SHAPE_SOUTH;
                    break;
                }
                case WEST: {
                    bottomShape = BOTTOM_RIGHT_SHAPE_WEST;
                    break;
                }
                default: {
                    bottomShape = BOTTOM_RIGHT_SHAPE_NORTH;
                    break;
                }
            }
        } else {
            bottomShape = BOTTOM_SELF_SHAPE;
        }
        return Shapes.or((VoxelShape)topShape, (VoxelShape)bottomShape);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean waterlogged = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        Direction facing = context.getHorizontalDirection().getOpposite();
        boolean isOpen = false;
        return this.getConnections((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(isOpen)), (LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return this.getConnections(state, level, currentPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, CONNECTED_LEFT, CONNECTED_RIGHT, WATERLOGGED, OPEN});
    }

    private BlockState getConnections(BlockState state, @Nullable LevelAccessor level, @Nullable BlockPos pos) {
        if (level == null || pos == null) {
            return (BlockState)((BlockState)state.setValue((Property)CONNECTED_LEFT, (Comparable)Boolean.valueOf(false))).setValue((Property)CONNECTED_RIGHT, (Comparable)Boolean.valueOf(false));
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        boolean left = this.validConnection(level.getBlockState(pos.relative(facing.getCounterClockWise())));
        boolean right = this.validConnection(level.getBlockState(pos.relative(facing.getClockWise())));
        return (BlockState)((BlockState)state.setValue((Property)CONNECTED_LEFT, (Comparable)Boolean.valueOf(left))).setValue((Property)CONNECTED_RIGHT, (Comparable)Boolean.valueOf(right));
    }

    private boolean validConnection(BlockState state) {
        return state.is(CFBlockTags.SINKS_CONNECTABLE);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        Direction newFacing = rotation.rotate((Direction)state.getValue((Property)FACING));
        return this.getConnections((BlockState)state.setValue((Property)FACING, (Comparable)newFacing), null, null);
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return this.rotate(state, mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

