/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.compat;

import com.lunazstudios.cobblefurnies.recipe.CountedIngredient;
import com.lunazstudios.cobblefurnies.recipe.FurniCraftingRecipe;
import com.lunazstudios.cobblefurnies.registry.CFBlocks;
import java.util.ArrayList;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class FurniCrafterRecipeCategory
implements IRecipeCategory<FurniCraftingRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"cobblefurnies", (String)"furni_crafting");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"cobblefurnies", (String)"textures/gui/jei/furnicrafter.png");
    public static final RecipeType<FurniCraftingRecipe> RECIPE_TYPE = new RecipeType(UID, FurniCraftingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public FurniCrafterRecipeCategory(IGuiHelper helper) {
        this.background = helper.drawableBuilder(TEXTURE, 0, 0, 150, 49).setTextureSize(150, 49).build();
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CFBlocks.FURNI_CRAFTER.get()));
    }

    public RecipeType<FurniCraftingRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.literal((String)"FurniCrafter");
    }

    @Nullable
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FurniCraftingRecipe recipe, IFocusGroup focuses) {
        NonNullList<CountedIngredient> ingredients = recipe.getMaterials();
        int slotCount = ingredients.size();
        int slotWidth = 18;
        int spacing = 2;
        int totalWidth = slotCount * slotWidth + (slotCount - 1) * spacing;
        int startX = (100 - totalWidth) / 2;
        int slotY = 16;
        for (int i = 0; i < slotCount; ++i) {
            int slotX = startX + i * (slotWidth + spacing);
            CountedIngredient ci = (CountedIngredient)ingredients.get(i);
            ItemStack[] alternatives = ci.ingredient().getItems();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (ItemStack stack : alternatives) {
                ItemStack copy = stack.copy();
                copy.setCount(ci.count());
                stacks.add(copy);
            }
            builder.addSlot(RecipeIngredientRole.INPUT, slotX, slotY).addItemStacks(stacks);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 115, 16).addItemStack(recipe.getResult());
    }
}

