/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.network.message;

import com.lunazstudios.cobblefurnies.menu.FurniCrafterMenu;
import com.lunazstudios.cobblefurnies.network.CFNetwork;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public record CraftRecipeMessage(int containerId, int recipeIndex) implements CustomPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, CraftRecipeMessage> CODEC = StreamCodec.of((buf, msg) -> {
        buf.writeInt(msg.containerId);
        buf.writeInt(msg.recipeIndex);
    }, buf -> new CraftRecipeMessage(buf.readInt(), buf.readInt()));

    public static void handle(CraftRecipeMessage message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            Player patt0$temp = context.getPlayer();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                AbstractContainerMenu patt1$temp = serverPlayer.containerMenu;
                if (patt1$temp instanceof FurniCrafterMenu) {
                    FurniCrafterMenu menu = (FurniCrafterMenu)patt1$temp;
                    if (menu.containerId == message.containerId) {
                        menu.craftSelectedRecipe(message.recipeIndex);
                    }
                }
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return CFNetwork.CRAFT_RECIPE_TYPE;
    }
}

