/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.network.message;

import com.lunazstudios.cobblefurnies.client.screen.FurniCrafterScreen;
import com.lunazstudios.cobblefurnies.menu.FurniCrafterMenu;
import com.lunazstudios.cobblefurnies.network.CFNetwork;
import dev.architectury.networking.NetworkManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.AbstractContainerMenu;

public record SyncCraftableRecipesMessage(int containerId, boolean[] craftable) implements CustomPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncCraftableRecipesMessage> CODEC = StreamCodec.of((buf, msg) -> {
        buf.writeInt(msg.containerId);
        buf.writeInt(msg.craftable.length);
        for (boolean b : msg.craftable) {
            buf.writeBoolean(b);
        }
    }, buf -> {
        int containerId = buf.readInt();
        int len = buf.readInt();
        boolean[] craftable = new boolean[len];
        for (int i = 0; i < len; ++i) {
            craftable[i] = buf.readBoolean();
        }
        return new SyncCraftableRecipesMessage(containerId, craftable);
    });

    public static void handle(SyncCraftableRecipesMessage message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            AbstractContainerMenu patt0$temp = Minecraft.getInstance().player.containerMenu;
            if (patt0$temp instanceof FurniCrafterMenu) {
                FurniCrafterMenu menu = (FurniCrafterMenu)patt0$temp;
                if (menu.containerId == message.containerId) {
                    menu.setCraftableRecipes(message.craftable);
                    Screen patt1$temp = Minecraft.getInstance().screen;
                    if (patt1$temp instanceof FurniCrafterScreen) {
                        FurniCrafterScreen screen = (FurniCrafterScreen)patt1$temp;
                        screen.updateRecipeButtons();
                    }
                }
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return CFNetwork.CRAFTABLE_RECIPES_SYNC_TYPE;
    }
}

