/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.dragonitegear.block.entity.custom;

import java.util.List;
import java.util.Optional;
import net.micaxs.dragonitegear.block.custom.DragoniteForgeBlock;
import net.micaxs.dragonitegear.block.entity.ModBlockEntities;
import net.micaxs.dragonitegear.recipe.DragoniteForgeRecipe;
import net.micaxs.dragonitegear.recipe.DragoniteForgeRecipeInput;
import net.micaxs.dragonitegear.recipe.ModRecipes;
import net.micaxs.dragonitegear.screen.custom.DragoniteForgeMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class DragoniteForgeBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler inventory = new ItemStackHandler(3){

        protected int getStackLimit(int slot, ItemStack stack) {
            return 64;
        }

        protected void onContentsChanged(int slot) {
            DragoniteForgeBlockEntity.this.setChanged();
            if (!DragoniteForgeBlockEntity.this.level.isClientSide()) {
                DragoniteForgeBlockEntity.this.level.sendBlockUpdated(DragoniteForgeBlockEntity.this.getBlockPos(), DragoniteForgeBlockEntity.this.getBlockState(), DragoniteForgeBlockEntity.this.getBlockState(), 3);
            }
        }
    };
    private static final int INPUT_SLOT_1 = 0;
    private static final int INPUT_SLOT_2 = 1;
    private static final int OUTPUT_SLOT = 2;
    private final ContainerData data = new ContainerData(){

        public int get(int i) {
            return switch (i) {
                case 0 -> DragoniteForgeBlockEntity.this.progress;
                case 1 -> DragoniteForgeBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void set(int i, int value) {
            switch (i) {
                case 0: {
                    DragoniteForgeBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    DragoniteForgeBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 600;
    private final int DEFAULT_MAX_PROGRESS = 600;

    public DragoniteForgeBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.DRAGONITE_FORGE_BE.get(), pos, blockState);
    }

    public void clearContents() {
        this.inventory.setStackInSlot(0, ItemStack.EMPTY);
        this.inventory.setStackInSlot(1, ItemStack.EMPTY);
        this.inventory.setStackInSlot(2, ItemStack.EMPTY);
    }

    public void drops() {
        SimpleContainer container = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < container.getContainerSize(); ++i) {
            container.setItem(i, this.inventory.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)container);
    }

    public void tick(Level level, BlockPos pPos, BlockState pState) {
        if (this.hasRecipe() && this.isOutputSlotEmptyorReceivable()) {
            this.increaseCraftingProgress();
            level.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)DragoniteForgeBlock.LIT, (Comparable)Boolean.valueOf(true)));
            DragoniteForgeBlockEntity.setChanged((Level)level, (BlockPos)pPos, (BlockState)pState);
            if (this.hasProgressFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
            level.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)DragoniteForgeBlock.LIT, (Comparable)Boolean.valueOf(false)));
        }
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = 600;
    }

    private void craftItem() {
        Optional<RecipeHolder<DragoniteForgeRecipe>> recipe = this.getCurrentRecipe();
        ItemStack output = ((DragoniteForgeRecipe)recipe.get().value()).output();
        this.inventory.extractItem(0, 1, false);
        this.inventory.extractItem(1, 1, false);
        this.inventory.setStackInSlot(2, new ItemStack((ItemLike)output.getItem(), this.inventory.getStackInSlot(2).getCount() + output.getCount()));
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private boolean isOutputSlotEmptyorReceivable() {
        return this.inventory.getStackInSlot(2).isEmpty() || this.inventory.getStackInSlot(2).getCount() < this.inventory.getStackInSlot(2).getMaxStackSize();
    }

    private boolean hasRecipe() {
        Optional<RecipeHolder<DragoniteForgeRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack output = ((DragoniteForgeRecipe)recipe.get().value()).getResultItem(null);
        return this.canInsertAmountIntoOutputSlot(output.getCount()) && this.canInsertItemIntoOutputSlot(output);
    }

    private Optional<RecipeHolder<DragoniteForgeRecipe>> getCurrentRecipe() {
        List<ItemStack> inputs = List.of(this.inventory.getStackInSlot(0), this.inventory.getStackInSlot(1));
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.DRAGONITE_FORGING_TYPE.get(), (RecipeInput)new DragoniteForgeRecipeInput(inputs), this.level);
    }

    private boolean canInsertItemIntoOutputSlot(ItemStack output) {
        return this.inventory.getStackInSlot(2).isEmpty() || this.inventory.getStackInSlot(2).getItem() == output.getItem();
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        int maxCount = this.inventory.getStackInSlot(2).isEmpty() ? 64 : this.inventory.getStackInSlot(2).getMaxStackSize();
        int currentCount = this.inventory.getStackInSlot(2).getCount();
        return maxCount >= currentCount + count;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.dragonitegear.dragonite_forge");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new DragoniteForgeMenu(i, inventory, this, this.data);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("dragoniteforge.inventory", (Tag)this.inventory.serializeNBT(registries));
        tag.putInt("dragoniteforge.progress", this.progress);
        tag.putInt("dragoniteforge.max_progress", this.maxProgress);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory.deserializeNBT(registries, tag.getCompound("dragoniteforge.inventory"));
        this.progress = tag.getInt("dragoniteforge.progress");
        this.maxProgress = tag.getInt("dragoniteforge.max_progress");
    }
}

