/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.dragonitegear.item.custom;

import java.util.List;
import net.micaxs.dragonitegear.entity.custom.DragontiteProjectileEntity;
import net.micaxs.dragonitegear.item.ModItems;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class DragoniteStaff
extends Item {
    public DragoniteStaff(Item.Properties properties) {
        super(properties.durability(256));
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return 1.0f;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemstack = player.getItemInHand(usedHand);
        if (!level.isClientSide) {
            DragoniteStaff.launchProjectile(level, player, 0.0f);
            if (!player.getAbilities().instabuild) {
                itemstack.hurtAndBreak(1, (ServerLevel)level, (ServerPlayer)player, item -> player.onEquippedItemBroken(item, EquipmentSlot.MAINHAND));
            }
        }
        player.getCooldowns().addCooldown((Item)this, 60);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
    }

    private static void launchProjectile(Level pLevel, Player pPlayer, float pOffset) {
        DragontiteProjectileEntity dragoniteProjectile = new DragontiteProjectileEntity(pLevel, (LivingEntity)pPlayer);
        dragoniteProjectile.setItem(((Item)ModItems.DRAGONITE_PROJECTILE.get()).getDefaultInstance());
        dragoniteProjectile.shootFromRotation((Entity)pPlayer, pPlayer.getXRot(), pPlayer.getYRot(), 0.0f, 2.5f, pOffset);
        pLevel.addFreshEntity((Entity)dragoniteProjectile);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.dragonitegear.dragonite_staff").withStyle(ChatFormatting.GRAY));
    }
}

