/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite.config;

import com.autovw.advancednetherite.api.annotation.Internal;
import com.autovw.advancednetherite.config.IClientConfig;
import com.autovw.advancednetherite.config.ICommonConfig;
import com.autovw.advancednetherite.config.IServerConfig;
import com.autovw.advancednetherite.config.common.IAdditionalDropsConfig;
import com.autovw.advancednetherite.config.server.IAdditionalDropPropertiesConfig;
import com.autovw.advancednetherite.config.server.IToolPropertiesConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

@Internal
public class Config {
    private static final ModConfigSpec.Builder CLIENT_BUILDER = new ModConfigSpec.Builder();
    public static final Client CLIENT = new Client(CLIENT_BUILDER);
    public static final ModConfigSpec CLIENT_SPEC = CLIENT_BUILDER.build();
    private static final ModConfigSpec.Builder COMMON_BUILDER = new ModConfigSpec.Builder();
    public static final Common COMMON = new Common(COMMON_BUILDER);
    public static final ModConfigSpec COMMON_SPEC = COMMON_BUILDER.build();
    private static final ModConfigSpec.Builder SERVER_BUILDER = new ModConfigSpec.Builder();
    public static final Server SERVER = new Server(SERVER_BUILDER);
    public static final ModConfigSpec SERVER_SPEC = SERVER_BUILDER.build();

    public static class Client
    implements IClientConfig {
        public static ModConfigSpec.BooleanValue showTooltips;
        public static ModConfigSpec.BooleanValue matchingDurabilityBars;
        public static ModConfigSpec.BooleanValue forceDisableDetailArmorBarSupport;

        public Client(ModConfigSpec.Builder builder) {
            builder.translation("config.advancednetherite.client").push("client");
            showTooltips = builder.comment("If true, displays tooltips, added by Advanced Netherite, with perks client-side. True by default.").translation("config.advancednetherite.client.show_tooltips").define("showTooltips", true);
            matchingDurabilityBars = builder.comment("If true, displays a (color) matching durability bar underneath the item when damaged. False by default.").translation("config.advancednetherite.client.matching_durability_bars").define("matchingDurabilityBars", false);
            forceDisableDetailArmorBarSupport = builder.comment("If true, forcefully disables support for Detail Armor Bar mod. Requires the game to be restarted. False by default.").translation("config.advancednetherite.client.force_disable_dab_support").define("forceDisableDetailArmorBarSupport", false);
            builder.pop();
        }

        @Override
        public boolean showTooltips() {
            return (Boolean)showTooltips.get();
        }

        @Override
        public boolean matchingDurabilityBars() {
            return (Boolean)matchingDurabilityBars.get();
        }

        @Override
        public boolean forceDisableDetailArmorBarSupport() {
            return (Boolean)forceDisableDetailArmorBarSupport.get();
        }
    }

    public static class Common
    implements ICommonConfig {
        public final AdditionalDropsConfig additionalDropsConfig;

        public Common(ModConfigSpec.Builder builder) {
            builder.translation("config.advancednetherite.common").push("common");
            this.additionalDropsConfig = new AdditionalDropsConfig(builder);
            builder.pop();
        }

        @Override
        public IAdditionalDropsConfig getAdditionalDrops() {
            return this.additionalDropsConfig;
        }
    }

    public static class Server
    implements IServerConfig {
        public final ToolProperties toolProperties;
        public final AdditionalDropProperties additionalDropProperties;

        public Server(ModConfigSpec.Builder builder) {
            builder.translation("config.advancednetherite.server").push("server");
            this.toolProperties = new ToolProperties(builder);
            this.additionalDropProperties = new AdditionalDropProperties(builder);
            builder.pop();
        }

        @Override
        public IAdditionalDropPropertiesConfig getAdditionalDropProperties() {
            return this.additionalDropProperties;
        }

        @Override
        public IToolPropertiesConfig getToolProperties() {
            return this.toolProperties;
        }
    }

    public static class AdditionalDropProperties
    implements IAdditionalDropPropertiesConfig {
        public static ModConfigSpec.DoubleValue additionalWheatDropChance;
        public static ModConfigSpec.DoubleValue additionalCarrotsDropChance;
        public static ModConfigSpec.DoubleValue additionalPotatoesDropChance;
        public static ModConfigSpec.DoubleValue additionalBeetrootsDropChance;
        public static ModConfigSpec.DoubleValue additionalPhantomDropChance;
        public static ModConfigSpec.DoubleValue additionalZombifiedPiglinDropChance;
        public static ModConfigSpec.DoubleValue additionalPiglinDropChance;
        public static ModConfigSpec.DoubleValue additionalEndermanDropChance;
        public static ModConfigSpec.DoubleValue additionalRawIronDropChance;
        public static ModConfigSpec.DoubleValue additionalRawGoldDropChance;
        public static ModConfigSpec.DoubleValue additionalEmeraldDropChance;
        public static ModConfigSpec.DoubleValue additionalDiamondDropChance;
        public static ModConfigSpec.DoubleValue additionalGoldNuggetDropChance;

        public AdditionalDropProperties(ModConfigSpec.Builder builder) {
            builder.comment("Configure properties related to additional drops here.").translation("config.advancednetherite.server.additional_drops").push("additional_drop_properties");
            builder.comment("Configure properties related to crop drop chances here.").translation("config.advancednetherite.server.additional_drops.crops").push("crop_drop_chances");
            additionalWheatDropChance = builder.comment("Chance of dropping additional wheat. 0.0 = 0% chance, 1.0 = 100% chance.").translation("config.advancednetherite.server.additional_drops.crops.wheat_drop_chance").defineInRange("additionalWheatDropChance", 0.3, 0.0, 1.0);
            additionalCarrotsDropChance = builder.comment("Chance of dropping additional carrots. 0.0 = 0% chance, 1.0 = 100% chance.").translation("config.advancednetherite.server.additional_drops.crops.carrots_drop_chance").defineInRange("additionalCarrotsDropChance", 0.3, 0.0, 1.0);
            additionalPotatoesDropChance = builder.comment("Chance of dropping additional potatoes. 0.0 = 0% chance, 1.0 = 100% chance.").translation("config.advancednetherite.server.additional_drops.crops.potatoes_drop_chance").defineInRange("additionalPotatoesDropChance", 0.3, 0.0, 1.0);
            additionalBeetrootsDropChance = builder.comment("Chance of dropping additional beetroots. 0.0 = 0% chance, 1.0 = 100% chance.").translation("config.advancednetherite.server.additional_drops.crops.beetroots_drop_chance").defineInRange("additionalBeetrootsDropChance", 0.2, 0.0, 1.0);
            builder.pop();
            builder.comment("Configure properties related to mob drop chances here.").translation("config.advancednetherite.server.additional_drops.mobs").push("mob_drop_chances");
            additionalPhantomDropChance = builder.comment("Chance of dropping additional phantom membrane. 0.0 = 0% chance, 1.0 = 100% chance.").translation("config.advancednetherite.server.additional_drops.mobs.phantom_drop_chance").defineInRange("additionalPhantomDropChance", 0.5, 0.0, 1.0);
            additionalZombifiedPiglinDropChance = builder.comment("Chance of dropping additional golden nuggets. 0.0 = 0% chance, 1.0 = 100% chance.").translation("config.advancednetherite.server.additional_drops.mobs.zombified_piglin_drop_chance").defineInRange("additionalZombifiedPiglinDropChance", 0.5, 0.0, 1.0);
            additionalPiglinDropChance = builder.comment("Chance of dropping additional golden ingots. 0.0 = 0% chance, 1.0 = 100% chance.").translation("config.advancednetherite.server.additional_drops.mobs.piglin_drop_chance").defineInRange("additionalPiglinDropChance", 0.15, 0.0, 1.0);
            additionalEndermanDropChance = builder.comment("Chance of dropping additional ender pearls. 0.0 = 0% chance, 1.0 = 100% chance.").translation("config.advancednetherite.server.additional_drops.mobs.enderman_drop_chance").defineInRange("additionalEndermanDropChance", 0.3, 0.0, 1.0);
            builder.pop();
            builder.comment("Configure properties related to ore drop chances here.").translation("config.advancednetherite.server.additional_drops.ores").push("ore_drop_chances");
            additionalRawIronDropChance = builder.comment("Chance of dropping additional raw iron. 0.0 = 0% chance, 1.0 = 100% chance.").translation("config.advancednetherite.server.additional_drops.ores.raw_iron_drop_chance").defineInRange("additionalRawIronDropChance", 0.2, 0.0, 1.0);
            additionalRawGoldDropChance = builder.comment("Chance of dropping additional raw gold. 0.0 = 0% chance, 1.0 = 100% chance.").translation("config.advancednetherite.server.additional_drops.ores.raw_gold_drop_chance").defineInRange("additionalRawGoldChance", 0.3, 0.0, 1.0);
            additionalEmeraldDropChance = builder.comment("Chance of dropping additional emerald. 0.0 = 0% chance, 1.0 = 100% chance.").translation("config.advancednetherite.server.additional_drops.ores.emerald_drop_chance").defineInRange("additionalEmeraldDropChance", 0.4, 0.0, 1.0);
            additionalDiamondDropChance = builder.comment("Chance of dropping additional diamond. 0.0 = 0% chance, 1.0 = 100% chance.").translation("config.advancednetherite.server.additional_drops.ores.diamond_drop_chance").defineInRange("additionalDiamondDropChance", 0.25, 0.0, 1.0);
            additionalGoldNuggetDropChance = builder.comment("Chance of dropping additional golden nugget. 0.0 = 0% chance, 1.0 = 100% chance.").translation("config.advancednetherite.server.additional_drops.ores.gold_nugget_drop_chance").defineInRange("additionalGoldNuggetDropChance", 0.6, 0.0, 1.0);
            builder.pop();
            builder.pop();
        }

        @Override
        public double getAdditionalWheatDropChance() {
            return (Double)additionalWheatDropChance.get();
        }

        @Override
        public double getAdditionalCarrotsDropChance() {
            return (Double)additionalCarrotsDropChance.get();
        }

        @Override
        public double getAdditionalPotatoesDropChance() {
            return (Double)additionalPotatoesDropChance.get();
        }

        @Override
        public double getAdditionalBeetrootsDropChance() {
            return (Double)additionalBeetrootsDropChance.get();
        }

        @Override
        public double getAdditionalPhantomDropChance() {
            return (Double)additionalPhantomDropChance.get();
        }

        @Override
        public double getAdditionalZombifiedPiglinDropChance() {
            return (Double)additionalZombifiedPiglinDropChance.get();
        }

        @Override
        public double getAdditionalPiglinDropChance() {
            return (Double)additionalPiglinDropChance.get();
        }

        @Override
        public double getAdditionalEndermanDropChance() {
            return (Double)additionalEndermanDropChance.get();
        }

        @Override
        public double getAdditionalRawIronDropChance() {
            return (Double)additionalRawIronDropChance.get();
        }

        @Override
        public double getAdditionalRawGoldDropChance() {
            return (Double)additionalRawGoldDropChance.get();
        }

        @Override
        public double getAdditionalEmeraldDropChance() {
            return (Double)additionalEmeraldDropChance.get();
        }

        @Override
        public double getAdditionalDiamondDropChance() {
            return (Double)additionalDiamondDropChance.get();
        }

        @Override
        public double getAdditionalGoldNuggetDropChance() {
            return (Double)additionalGoldNuggetDropChance.get();
        }
    }

    public static class ToolProperties
    implements IToolPropertiesConfig {
        public static ModConfigSpec.IntValue ironBreakingSpeedMultiplier;
        public static ModConfigSpec.IntValue goldBreakingSpeedMultiplier;
        public static ModConfigSpec.IntValue emeraldBreakingSpeedMultiplier;
        public static ModConfigSpec.IntValue diamondBreakingSpeedMultiplier;

        public ToolProperties(ModConfigSpec.Builder builder) {
            builder.comment("Configure properties related to tools here.").translation("config.advancednetherite.server.tool_properties").push("tool_properties");
            builder.comment("Configure tool properties related to block breaking speed here.").translation("config.advancednetherite.server.tool_properties.breaking_speed_multipliers").push("breaking_speed_multipliers");
            ironBreakingSpeedMultiplier = builder.comment("Block breaking speed multiplier for Netherite-Iron tools").translation("config.advancednetherite.server.tool_properties.breaking_speed_multipliers.netherite_iron").defineInRange("ironBreakingSpeedMultiplier", 12, 1, 64);
            goldBreakingSpeedMultiplier = builder.comment("Block breaking speed multiplier for Netherite-Gold tools").translation("config.advancednetherite.server.tool_properties.breaking_speed_multipliers.netherite_gold").defineInRange("goldBreakingSpeedMultiplier", 20, 1, 64);
            emeraldBreakingSpeedMultiplier = builder.comment("Block breaking speed multiplier for Netherite-Emerald tools").translation("config.advancednetherite.server.tool_properties.breaking_speed_multipliers.netherite_emerald").defineInRange("emeraldBreakingSpeedMultiplier", 29, 1, 64);
            diamondBreakingSpeedMultiplier = builder.comment("Block breaking speed multiplier for Netherite-Diamond tools").translation("config.advancednetherite.server.tool_properties.breaking_speed_multipliers.netherite_diamond").defineInRange("diamondBreakingSpeedMultiplier", 39, 1, 64);
            builder.pop();
            builder.pop();
        }

        @Override
        public int getIronBreakingSpeedMultiplier() {
            return (Integer)ironBreakingSpeedMultiplier.get();
        }

        @Override
        public int getGoldBreakingSpeedMultiplier() {
            return (Integer)goldBreakingSpeedMultiplier.get();
        }

        @Override
        public int getEmeraldBreakingSpeedMultiplier() {
            return (Integer)emeraldBreakingSpeedMultiplier.get();
        }

        @Override
        public int getDiamondBreakingSpeedMultiplier() {
            return (Integer)diamondBreakingSpeedMultiplier.get();
        }
    }

    public static class AdditionalDropsConfig
    implements IAdditionalDropsConfig {
        public static ModConfigSpec.BooleanValue enableAdditionalCropDrops;
        public static ModConfigSpec.BooleanValue enableAdditionalOreDrops;
        public static ModConfigSpec.BooleanValue enableAdditionalMobDrops;

        public AdditionalDropsConfig(ModConfigSpec.Builder builder) {
            builder.comment("Configure properties related to additional drop perks here. Drop chances can be modified in the SERVER config.").translation("config.advancednetherite.common.additional_drops").push("additional_drops");
            enableAdditionalCropDrops = builder.comment("If true, enables additional crop drops for hoes. True by default.").translation("config.advancednetherite.common.additional_drops.enable_additional_crop_drops").define("enableAdditionalCropDrops", true);
            enableAdditionalOreDrops = builder.comment("If true, enables additional ore drops for pickaxes. Pickaxes with Silk Touch remain unaffected. True by default.").translation("config.advancednetherite.common.additional_drops.enable_additional_ore_drops").define("enableAdditionalOreDrops", true);
            enableAdditionalMobDrops = builder.comment("If true, enables additional mob drops for swords. True by default.").translation("config.advancednetherite.common.additional_drops.enable_additional_mob_drops").define("enableAdditionalMobDrops", true);
            builder.pop();
        }

        @Override
        public boolean enableAdditionalCropDrops() {
            return (Boolean)enableAdditionalCropDrops.get();
        }

        @Override
        public boolean enableAdditionalOreDrops() {
            return (Boolean)enableAdditionalOreDrops.get();
        }

        @Override
        public boolean enableAdditionalMobDrops() {
            return (Boolean)enableAdditionalMobDrops.get();
        }
    }
}

