/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite.config;

import com.autovw.advancednetherite.api.annotation.Internal;
import com.autovw.advancednetherite.config.IClientConfig;
import com.autovw.advancednetherite.config.ICommonConfig;
import com.autovw.advancednetherite.config.IServerConfig;
import java.util.function.Supplier;

public final class ConfigHelper {
    private static Supplier<IClientConfig> clientConfig;
    private static Supplier<ICommonConfig> commonConfig;
    private static Supplier<IServerConfig> serverConfig;
    private static ConfigHelper helper;

    public static ConfigHelper get() {
        if (helper == null) {
            helper = new ConfigHelper();
        }
        return helper;
    }

    @Internal
    public static void registerClientConfig(Supplier<IClientConfig> clientConfig) {
        if (ConfigHelper.clientConfig == null) {
            ConfigHelper.clientConfig = clientConfig;
        }
    }

    @Internal
    public static void registerCommonConfig(Supplier<ICommonConfig> commonConfig) {
        if (ConfigHelper.commonConfig == null) {
            ConfigHelper.commonConfig = commonConfig;
        }
    }

    @Internal
    public static void registerServerConfig(Supplier<IServerConfig> serverConfig) {
        if (ConfigHelper.serverConfig == null) {
            ConfigHelper.serverConfig = serverConfig;
        }
    }

    private ConfigHelper() {
    }

    public IClientConfig getClient() {
        return clientConfig.get();
    }

    public ICommonConfig getCommon() {
        return commonConfig.get();
    }

    public IServerConfig getServer() {
        return serverConfig.get();
    }
}

