/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.view.element;

import java.util.function.Consumer;
import me.ichun.mods.ichunutil.client.gui.bns.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;

public abstract class ElementClickable<T extends ElementClickable>
extends Element<Fragment<?>> {
    @NotNull
    public Consumer<T> callback;
    public boolean hover;
    public boolean disabled;

    public ElementClickable(@NotNull Fragment parent, Consumer<T> callback) {
        super(parent);
        this.callback = callback;
    }

    public <T extends ElementClickable<?>> T setDisabled(boolean flag) {
        this.disabled = flag;
        return (T)this;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.hover = false;
        if (!this.disabled) {
            this.hover = this.isMouseOver(mouseX, mouseY) || ((Fragment)this.parent).getFocused() == this;
        }
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        boolean flag = super.mouseReleased(mouseX, mouseY, button);
        ((Fragment)this.parent).setFocused(null);
        if (!this.disabled && this.isMouseOver(mouseX, mouseY) && button == 0) {
            this.trigger();
        }
        return flag;
    }

    public void trigger() {
        if (this.renderMinecraftStyle() > 0) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        }
        this.onClickRelease();
        this.callback.accept(this);
    }

    public abstract void onClickRelease();

    public boolean keyPressed(int key, int scancode, int listener) {
        if (!(this.disabled || key != 32 && key != 257 && key != 335)) {
            this.trigger();
            return true;
        }
        return false;
    }

    @Override
    public int getMinecraftFontColour() {
        return ((Fragment)this.parent).isDragging() && ((Fragment)this.parent).getFocused() == this || this.disabled ? 0xA0A0A0 : (this.hover ? 0xFFFFA0 : 0xE0E0E0);
    }
}

