/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.view.element;

import java.util.ArrayList;
import java.util.List;
import me.ichun.mods.ichunutil.client.gui.bns.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.Theme;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementTextWrapper
extends Element<Fragment<?>> {
    private List<String> text = new ArrayList<String>();
    private List<String> textWrapped = new ArrayList<String>();
    private boolean doNotWrap;
    public int longestLine;
    @Nullable
    public Integer color;

    public ElementTextWrapper(@NotNull Fragment<?> parent) {
        super(parent);
    }

    public <T extends ElementTextWrapper> T setText(List<String> text) {
        this.text.clear();
        this.text.addAll(text);
        return (T)this;
    }

    public <T extends ElementTextWrapper> T setText(String text) {
        this.text.clear();
        this.text.add(text);
        return (T)this;
    }

    public <T extends ElementTextWrapper> T setNoWrap() {
        this.doNotWrap = true;
        return (T)this;
    }

    public <T extends ElementTextWrapper> T setColor(Integer clr) {
        this.color = clr;
        return (T)this;
    }

    public List<String> getText() {
        return this.text;
    }

    @Override
    public void init() {
        super.init();
        if (!this.text.isEmpty() && this.setupText()) {
            this.constraint.apply();
            ((Fragment)this.parent).resize(((Workspace)this.getWorkspace()).getMinecraft(), ((Fragment)this.parent).getParentWidth(), ((Fragment)this.parent).getParentHeight());
        }
    }

    @Override
    public void resize(Minecraft mc, int width, int height) {
        super.resize(mc, width, height);
        if (!this.text.isEmpty() && this.setupText()) {
            this.constraint.apply();
            ((Fragment)this.parent).resize(((Workspace)this.getWorkspace()).getMinecraft(), ((Fragment)this.parent).getParentWidth(), ((Fragment)this.parent).getParentHeight());
        }
    }

    public boolean setupText() {
        int lines = this.textWrapped.size();
        int tooltipTextWidth = 0;
        for (String textLine : this.text) {
            int textLineWidth = this.getFontRenderer().width(textLine);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        this.longestLine = tooltipTextWidth;
        if (this.doNotWrap) {
            this.textWrapped = this.text;
            return this.textWrapped.size() != lines;
        }
        boolean needsWrap = false;
        if (tooltipTextWidth > this.width - 4) {
            tooltipTextWidth = this.width - 4;
            needsWrap = true;
        }
        ArrayList<String> wrappedTextLines = new ArrayList<String>();
        for (String textLine : this.text) {
            if (textLine.isEmpty()) {
                wrappedTextLines.add(textLine);
                continue;
            }
            List texts = this.getFontRenderer().getSplitter().splitLines((FormattedText)Component.literal((String)textLine), needsWrap ? tooltipTextWidth : this.longestLine, Style.EMPTY);
            for (FormattedText text : texts) {
                wrappedTextLines.add(text.getString());
            }
        }
        this.textWrapped = wrappedTextLines;
        return lines != this.textWrapped.size();
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int textX = this.getLeft() + 2;
        int textY = this.getTop() + 4;
        for (int lineNumber = 0; lineNumber < this.textWrapped.size(); ++lineNumber) {
            String line = this.textWrapped.get(lineNumber);
            this.drawString(graphics, line, textX, textY);
            textY += 12;
        }
    }

    @Override
    public void drawString(GuiGraphics graphics, String s, float posX, float posY) {
        graphics.drawString(this.getFontRenderer(), s, (int)posX, (int)posY, this.color != null ? this.color : (this.renderMinecraftStyle() > 0 ? this.getMinecraftFontColour() : Theme.getAsHex(this.getTheme().font)), this.renderMinecraftStyle() > 0);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }

    @Override
    public ComponentPath nextFocusPath(FocusNavigationEvent event) {
        return null;
    }

    @Override
    public int getMinWidth() {
        return this.doNotWrap ? this.longestLine : 4;
    }

    @Override
    public int getMinHeight() {
        return this.textWrapped.isEmpty() ? 12 : this.textWrapped.size() * 12 + 4;
    }

    @Override
    public int getMaxWidth() {
        return this.getParentWidth() - 4;
    }

    @Override
    public int getMaxHeight() {
        return this.getMinHeight();
    }
}

