/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.view.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.function.Consumer;
import me.ichun.mods.ichunutil.client.gui.bns.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.Theme;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementClickable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementToggle<T extends ElementToggle>
extends ElementClickable<T> {
    public String text;
    public boolean toggleState;

    public ElementToggle(@NotNull Fragment parent, @NotNull String s, Consumer<T> callback) {
        super(parent, callback);
        this.text = !s.isEmpty() ? I18n.get((String)s, (Object[])new Object[0]) : "";
    }

    public <T extends ElementToggle<?>> T setToggled(boolean flag) {
        this.toggleState = flag;
        return (T)this;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.render(graphics, mouseX, mouseY, partialTick);
        PoseStack stack = graphics.pose();
        if (this.renderMinecraftStyle() > 0) {
            this.renderMinecraftStyleButton(stack, this.getLeft(), this.getTop(), this.width, this.height, this.disabled || ((Fragment)this.parent).isDragging() && ((Fragment)this.parent).getFocused() == this || this.toggleState ? Element.ButtonState.CLICK : (this.hover ? Element.ButtonState.HOVER : Element.ButtonState.IDLE));
        } else {
            this.fill(graphics, this.getTheme().elementButtonBorder, 0);
            int[] colour = this.disabled ? this.getTheme().elementButtonBackgroundInactive : (((Fragment)this.parent).isDragging() && ((Fragment)this.parent).getFocused() == this ? this.getTheme().elementButtonClick : (this.toggleState && this.hover ? this.getTheme().elementButtonToggleHover : (this.hover ? this.getTheme().elementButtonBackgroundHover : (this.toggleState ? this.getTheme().elementButtonToggle : this.getTheme().elementButtonBackgroundActive))));
            this.fill(graphics, colour, 1);
        }
        this.renderText(graphics);
    }

    public void renderText(GuiGraphics graphics) {
        if (!this.text.isEmpty()) {
            String s = this.reString(this.text, this.width - 4);
            Font font = this.getFontRenderer();
            int n = (int)((float)this.getLeft() + (float)(this.width - this.getFontRenderer().width(s)) / 2.0f);
            float f = this.getTop();
            Objects.requireNonNull(this.getFontRenderer());
            graphics.drawString(font, s, n, (int)(f + (float)(this.height - 9) / 2.0f + 1.0f), this.renderMinecraftStyle() > 0 ? this.getMinecraftFontColour() : Theme.getAsHex(this.getTheme().font), this.renderMinecraftStyle() > 0);
        }
    }

    @Override
    @Nullable
    public String tooltip(double mouseX, double mouseY) {
        String s;
        if (!this.text.isEmpty() && !(s = this.reString(this.text, this.width - 4)).equals(this.text)) {
            String tooltip = super.tooltip(mouseX, mouseY);
            if (tooltip != null) {
                return this.text + " - " + tooltip;
            }
            return this.text;
        }
        return super.tooltip(mouseX, mouseY);
    }

    @Override
    public void onClickRelease() {
        this.toggleState = !this.toggleState;
    }

    @Override
    public int getMinWidth() {
        return 14;
    }

    @Override
    public int getMinHeight() {
        return 14;
    }
}

