/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.compat;

import com.qendolin.betterclouds.BetterCloudsStatic;
import com.qendolin.betterclouds.platform.ModLoader;
import com.qendolin.betterclouds.platform.ModVersion;

public class YACLCompat {
    public static final ModVersion.SemVer Version3_8_0 = new ModVersion.SemVer(3, 8, 0);
    private static ModVersion.SemVer version;
    private static boolean isVersion3_8_0;

    public static void initialize() {
        BetterCloudsStatic.getLogger().info("YACL: initializing compat");
        ModVersion version = ModLoader.getModVersion("yet_another_config_lib_v3");
        if (version == null) {
            throw new RuntimeException("Could not get YACL version");
        }
        ModVersion.SemVer semver = version.asSemVer().orElseThrow(() -> new RuntimeException("Could not parse YACL version: " + version.getFriendlyString()));
        if (semver.major != 3) {
            throw new RuntimeException("Unsupported YACL version. Must be 3.*.*: " + version.getFriendlyString());
        }
        YACLCompat.version = semver;
        isVersion3_8_0 = semver.compareTo(Version3_8_0) >= 0;
    }

    public static ModVersion.SemVer getVersion() {
        return version;
    }

    public static boolean isVersion3_8_0() {
        return isVersion3_8_0;
    }
}

