/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.CursorType;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.MismatchingParentPanelException;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.KeyModifiers;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.PositionedIngredient;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public abstract class Panel
extends Widget {
    protected final List<Widget> widgets = new ArrayList<Widget>();
    private double scrollX = 0.0;
    private double scrollY = 0.0;
    private int offsetX = 0;
    private int offsetY = 0;
    private boolean onlyRenderWidgetsInside = true;
    private boolean onlyInteractWithWidgetsInside = true;
    private double scrollStep = 20.0;
    private int contentWidth = -1;
    private int contentHeight = -1;
    private int contentWidthExtra;
    private int contentHeightExtra;
    private PanelScrollBar attachedScrollbar = null;

    public Panel(Panel panel) {
        super(panel);
    }

    public boolean getOnlyRenderWidgetsInside() {
        return this.onlyRenderWidgetsInside;
    }

    public void setOnlyRenderWidgetsInside(boolean value) {
        this.onlyRenderWidgetsInside = value;
    }

    public boolean getOnlyInteractWithWidgetsInside() {
        return this.onlyInteractWithWidgetsInside;
    }

    public void setOnlyInteractWithWidgetsInside(boolean value) {
        this.onlyInteractWithWidgetsInside = value;
    }

    public List<Widget> getWidgets() {
        return this.widgets;
    }

    public abstract void addWidgets();

    public abstract void alignWidgets();

    public void clearWidgets() {
        this.widgets.clear();
    }

    public void refreshWidgets() {
        this.contentHeight = -1;
        this.contentWidth = -1;
        this.clearWidgets();
        try {
            this.addWidgets();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.widgets.sort(null);
        for (Widget widget : this.widgets) {
            if (!(widget instanceof Panel)) continue;
            Panel p = (Panel)widget;
            p.refreshWidgets();
        }
        this.alignWidgets();
    }

    public void add(Widget widget) {
        if (widget.parent != this) {
            throw new MismatchingParentPanelException(this, widget);
        }
        if (widget instanceof PanelScrollBar) {
            PanelScrollBar psb;
            this.attachedScrollbar = psb = (PanelScrollBar)widget;
        }
        this.widgets.add(widget);
        this.contentHeight = -1;
        this.contentWidth = -1;
    }

    public void addAll(Iterable<? extends Widget> list) {
        for (Widget widget : list) {
            this.add(widget);
        }
    }

    public final int align(WidgetLayout layout) {
        this.contentHeight = -1;
        this.contentWidth = -1;
        int res = layout.align(this);
        this.contentHeightExtra = layout.getLayoutPadding().vertical();
        this.contentWidthExtra = layout.getLayoutPadding().horizontal();
        return res;
    }

    @Override
    public int getX() {
        return super.getX() + this.offsetX;
    }

    @Override
    public int getY() {
        return super.getY() + this.offsetY;
    }

    public int getContentWidth() {
        if (this.contentWidth == -1) {
            int minX = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            for (Widget widget : this.widgets) {
                if (widget.posX < minX) {
                    minX = widget.posX;
                }
                if (widget.posX + widget.width <= maxX) continue;
                maxX = widget.posX + widget.width;
            }
            this.contentWidth = maxX - minX + this.contentWidthExtra;
        }
        return this.contentWidth;
    }

    public int getContentHeight() {
        if (this.contentHeight == -1) {
            int minY = Integer.MAX_VALUE;
            int maxY = Integer.MIN_VALUE;
            for (Widget widget : this.widgets) {
                if (widget.posY < minY) {
                    minY = widget.posY;
                }
                if (widget.posY + widget.height <= maxY) continue;
                maxY = widget.posY + widget.height;
            }
            this.contentHeight = maxY - minY + this.contentHeightExtra;
        }
        return this.contentHeight;
    }

    public boolean isOffset() {
        return this.offsetX != 0 || this.offsetY != 0;
    }

    public void setOffset(boolean flag) {
        if (flag) {
            this.offsetX = (int)(-this.scrollX);
            this.offsetY = (int)(-this.scrollY);
        } else {
            this.offsetY = 0;
            this.offsetX = 0;
        }
    }

    public double getScrollX() {
        return this.scrollX;
    }

    public void setScrollX(double scroll) {
        this.scrollX = scroll;
    }

    public double getScrollY() {
        return this.scrollY;
    }

    public void setScrollY(double scroll) {
        this.scrollY = scroll;
    }

    @Override
    public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        boolean renderInside = this.getOnlyRenderWidgetsInside();
        this.drawBackground(graphics, theme, x, y, w, h);
        if (renderInside) {
            GuiHelper.pushScissor(this.getScreen(), x, y, w, h);
        }
        this.setOffset(true);
        this.widgets.stream().filter(widget -> widget.shouldRenderInLayer(Widget.DrawLayer.BACKGROUND, x, y, w, h)).forEach(widget -> this.drawWidget(graphics, theme, (Widget)widget, x + this.offsetX, y + this.offsetY, w, h));
        this.drawOffsetBackground(graphics, theme, x + this.offsetX, y + this.offsetY, w, h);
        this.widgets.stream().filter(widget -> widget.shouldRenderInLayer(Widget.DrawLayer.FOREGROUND, x, y, w, h)).forEach(widget -> this.drawWidget(graphics, theme, (Widget)widget, x + this.offsetX, y + this.offsetY, w, h));
        this.setOffset(false);
        if (renderInside) {
            GuiHelper.popScissor(this.getScreen());
        }
    }

    public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
    }

    public void drawOffsetBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
    }

    public void drawWidget(GuiGraphics graphics, Theme theme, Widget widget, int x, int y, int w, int h) {
        int wx = widget.getX();
        int wy = widget.getY();
        int ww = widget.width;
        int wh = widget.height;
        widget.draw(graphics, theme, wx, wy, ww, wh);
        if (Theme.renderDebugBoxes) {
            Color4I col = Color4I.rgb(Color4I.HSBtoRGB((float)(widget.hashCode() & 0xFF) / 255.0f, 1.0f, 1.0f));
            GuiHelper.drawHollowRect(graphics, wx, wy, ww, wh, col.withAlpha(150), false);
            col.withAlpha(30).draw(graphics, wx + 1, wy + 1, ww - 2, wh - 2);
        }
    }

    @Override
    public void addMouseOverText(TooltipList list) {
        if (!this.shouldAddMouseOverText() || this.getOnlyInteractWithWidgetsInside() && !this.isMouseOver()) {
            return;
        }
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.shouldAddMouseOverText()) continue;
            widget.addMouseOverText(list);
            if (!Theme.renderDebugBoxes) continue;
            list.styledString(String.valueOf(widget) + "#" + (i + 1) + ": " + widget.width + "x" + widget.height, ChatFormatting.DARK_GRAY);
        }
        this.setOffset(false);
    }

    @Override
    public void updateMouseOver(int mouseX, int mouseY) {
        super.updateMouseOver(mouseX, mouseY);
        this.setOffset(true);
        for (Widget widget : this.widgets) {
            widget.updateMouseOver(mouseX, mouseY);
        }
        this.setOffset(false);
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        if (this.getOnlyInteractWithWidgetsInside() && !this.isMouseOver()) {
            return false;
        }
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled() || !widget.shouldDraw() || !widget.mousePressed(button)) continue;
            this.setOffset(false);
            return true;
        }
        this.setOffset(false);
        return false;
    }

    @Override
    public boolean mouseDoubleClicked(MouseButton button) {
        if (this.getOnlyInteractWithWidgetsInside() && !this.isMouseOver()) {
            return false;
        }
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled() || !widget.mouseDoubleClicked(button)) continue;
            this.setOffset(false);
            return true;
        }
        this.setOffset(false);
        return false;
    }

    @Override
    public void mouseReleased(MouseButton button) {
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled()) continue;
            widget.mouseReleased(button);
        }
        this.setOffset(false);
    }

    @Override
    public boolean mouseScrolled(double scroll) {
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled() || !widget.mouseScrolled(scroll)) continue;
            this.setOffset(false);
            return true;
        }
        boolean scrollPanel = this.scrollPanel(scroll);
        this.setOffset(false);
        return scrollPanel;
    }

    @Override
    public boolean mouseDragged(int button, double dragX, double dragY) {
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled() || !widget.mouseDragged(button, dragX, dragY)) continue;
            this.setOffset(false);
            return true;
        }
        this.setOffset(false);
        return false;
    }

    public boolean scrollPanel(double scroll) {
        if (this.attachedScrollbar != null || !this.isMouseOver()) {
            return false;
        }
        if (this.isDefaultScrollVertical() != Panel.isShiftKeyDown()) {
            return this.movePanelScroll(0.0, -this.getScrollStep() * scroll);
        }
        return this.movePanelScroll(-this.getScrollStep() * scroll, 0.0);
    }

    public boolean movePanelScroll(double dx, double dy) {
        int h;
        int w;
        if (dx == 0.0 && dy == 0.0) {
            return false;
        }
        double sx = this.getScrollX();
        double sy = this.getScrollY();
        if (dx != 0.0 && (w = this.getContentWidth()) > this.width) {
            this.setScrollX(Mth.clamp((double)(sx + dx), (double)0.0, (double)(w - this.width)));
        }
        if (dy != 0.0 && (h = this.getContentHeight()) > this.height) {
            this.setScrollY(Mth.clamp((double)(sy + dy), (double)0.0, (double)(h - this.height)));
        }
        return this.getScrollX() != sx || this.getScrollY() != sy;
    }

    public boolean isDefaultScrollVertical() {
        return true;
    }

    public double getScrollStep() {
        return this.scrollStep;
    }

    public void setScrollStep(double s) {
        this.scrollStep = s;
    }

    @Override
    public boolean keyPressed(Key key) {
        if (super.keyPressed(key)) {
            return true;
        }
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled() || !widget.keyPressed(key)) continue;
            this.setOffset(false);
            return true;
        }
        this.setOffset(false);
        return false;
    }

    @Override
    public void keyReleased(Key key) {
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled()) continue;
            widget.keyReleased(key);
        }
        this.setOffset(false);
    }

    @Override
    public boolean charTyped(char c, KeyModifiers modifiers) {
        if (super.charTyped(c, modifiers)) {
            return true;
        }
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled() || !widget.charTyped(c, modifiers)) continue;
            this.setOffset(false);
            return true;
        }
        this.setOffset(false);
        return false;
    }

    @Override
    public void onClosed() {
        for (Widget widget : this.widgets) {
            widget.onClosed();
        }
    }

    @Nullable
    public Widget getWidget(int index) {
        return index < 0 || index >= this.widgets.size() ? null : this.widgets.get(index);
    }

    @Override
    public Optional<PositionedIngredient> getIngredientUnderMouse() {
        this.setOffset(true);
        Optional<PositionedIngredient> result = Optional.empty();
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Optional<PositionedIngredient> ingredient;
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled() || !widget.isMouseOver() || !(ingredient = widget.getIngredientUnderMouse()).isPresent()) continue;
            result = ingredient;
            break;
        }
        this.setOffset(false);
        return result;
    }

    @Override
    public void tick() {
        this.setOffset(true);
        for (Widget widget : this.widgets) {
            if (!widget.isEnabled()) continue;
            widget.tick();
        }
        this.setOffset(false);
    }

    public boolean isMouseOverAnyWidget() {
        for (Widget widget : this.widgets) {
            if (!widget.isMouseOver()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public CursorType getCursor() {
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            CursorType cursor;
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled() || !widget.isMouseOver() || (cursor = widget.getCursor()) == null) continue;
            this.setOffset(false);
            return cursor;
        }
        this.setOffset(false);
        return null;
    }
}

