/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.defaultoptions;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import net.blay09.mods.defaultoptions.DefaultOptions;
import net.blay09.mods.defaultoptions.DefaultOptionsHandlerException;
import net.blay09.mods.defaultoptions.DefaultOptionsKeyMapping;
import net.blay09.mods.defaultoptions.InternalMethodsImpl;
import net.blay09.mods.defaultoptions.api.DefaultOptionsAPI;
import net.blay09.mods.defaultoptions.api.DefaultOptionsHandler;
import net.blay09.mods.defaultoptions.api.DefaultOptionsLoadStage;
import net.blay09.mods.defaultoptions.api.DefaultOptionsPlugin;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Options;

public class DefaultOptionsInitializer {
    private static final Set<String> userSeenKeys = new HashSet<String>();

    public static void preLoad(Options options) {
        if (options.getFile().exists()) {
            DefaultOptions.logger.info("options.txt already exists - last modified {}", (Object)options.getFile().lastModified());
        }
        DefaultOptionsInitializer.collectSeenKeys(options);
        DefaultOptionsInitializer.loadDefaults(DefaultOptionsLoadStage.PRE_LOAD);
    }

    public static void postLoad() {
        DefaultOptionsInitializer.loadDefaults(DefaultOptionsLoadStage.POST_LOAD);
    }

    private static void loadDefaults(DefaultOptionsLoadStage stage) {
        for (DefaultOptionsHandler handler : DefaultOptions.getDefaultOptionsHandlers()) {
            if (handler.getLoadStage() != stage) continue;
            if (handler.shouldLoadDefaults()) {
                try {
                    handler.loadDefaults();
                    DefaultOptions.logger.info("Loaded default options for {}", (Object)handler.getId());
                }
                catch (DefaultOptionsHandlerException e) {
                    DefaultOptions.logger.error("Failed to load default options for {}", (Object)e.getHandlerId(), (Object)e);
                }
                continue;
            }
            if (handler.hasDefaults()) {
                DefaultOptions.logger.debug("Skipping default options for {}; defaults are present but should not be loaded", (Object)handler.getId());
                continue;
            }
            DefaultOptions.logger.debug("Skipping default options for {}; no defaults available", (Object)handler.getId());
        }
    }

    public static void postSave() {
        for (DefaultOptionsHandler handler : DefaultOptions.getDefaultOptionsHandlers()) {
            handler.saveAdditional();
        }
    }

    public static void collectSeenKeys(Options options) {
        try (BufferedReader reader = Files.newReader((File)options.getFile(), (Charset)Charsets.UTF_8);){
            reader.lines().forEach(line -> {
                try {
                    int colonIndex;
                    if (line.startsWith("key_") && (colonIndex = line.indexOf(58)) != -1) {
                        String key = line.substring(0, colonIndex);
                        String name = key.substring("key_".length());
                        userSeenKeys.add(name);
                        DefaultOptions.logger.debug("Key {} is already configured in options.txt", (Object)name);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void markUserSeenKeys(Options options) {
        for (KeyMapping keyMapping : options.keyMappings) {
            if (!userSeenKeys.contains(keyMapping.getName())) continue;
            ((DefaultOptionsKeyMapping)keyMapping).defaultoptions$setSeen(true);
        }
    }

    static {
        DefaultOptionsAPI.__internalMethods = new InternalMethodsImpl();
        ServiceLoader<DefaultOptionsPlugin> loader = ServiceLoader.load(DefaultOptionsPlugin.class);
        loader.forEach(DefaultOptionsPlugin::initialize);
    }
}

