/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.client.entity;

import com.berksire.furniture.core.registry.EntityTypeRegistry;
import com.berksire.furniture.core.registry.ObjectRegistry;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.PaintingVariantTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CanvasEntity
extends Painting {
    public CanvasEntity(EntityType<? extends Painting> type, Level level) {
        super(type, level);
    }

    public CanvasEntity(Level level, BlockPos blockPos) {
        super(level, blockPos);
    }

    public CanvasEntity(Level level, BlockPos pos, Direction direction, Holder<PaintingVariant> variant) {
        super((EntityType)EntityTypeRegistry.CANVAS.get(), level);
        this.setPos(pos.getX(), pos.getY(), pos.getZ());
        this.setDirection(direction);
        this.setVariant(variant);
        this.fixPosition();
    }

    public static Optional<CanvasEntity> createCanvas(Level level, BlockPos blockPos, Direction direction) {
        CanvasEntity canvasEntity = new CanvasEntity(level, blockPos);
        ArrayList<Holder> list = new ArrayList<Holder>();
        level.registryAccess().registryOrThrow(Registries.PAINTING_VARIANT).getTagOrEmpty(PaintingVariantTags.PLACEABLE).forEach(list::add);
        Objects.requireNonNull(list);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        canvasEntity.setDirection(direction);
        list.removeIf(holder -> {
            canvasEntity.setVariant((Holder)holder);
            return !canvasEntity.survives();
        });
        if (list.isEmpty()) {
            return Optional.empty();
        }
        int i = list.stream().mapToInt(CanvasEntity::variantArea).max().orElse(0);
        list.removeIf(holder -> CanvasEntity.variantArea((Holder<PaintingVariant>)holder) < i);
        Optional optional = Util.getRandomSafe(list, (RandomSource)canvasEntity.random);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        canvasEntity.setVariant((Holder)optional.get());
        canvasEntity.setDirection(direction);
        return Optional.of(canvasEntity);
    }

    private void fixPosition() {
        this.setPos(this.getX(), this.getY(), this.getZ());
    }

    public ItemEntity spawnAtLocation(ItemLike item) {
        return super.spawnAtLocation((ItemLike)ObjectRegistry.CANVAS.get());
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)ObjectRegistry.CANVAS.get());
    }

    private static int variantArea(Holder<PaintingVariant> variant) {
        return ((PaintingVariant)variant.value()).area();
    }
}

