/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.client.entity;

import com.berksire.furniture.core.block.entity.FishTankBlockEntity;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3d;

public class FakeFishTankEntity
extends Entity {
    public AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;

    public FakeFishTankEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public boolean canCollideWith(Entity entity) {
        return false;
    }

    public boolean isColliding(BlockPos blockPos, BlockState blockState) {
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public Optional<FishTankBlockEntity> getNearestTankEntity() {
        BlockEntity blockEntity = this.level().getBlockEntity(this.blockPosition());
        if (blockEntity instanceof FishTankBlockEntity) {
            FishTankBlockEntity be = (FishTankBlockEntity)blockEntity;
            return Optional.of(be);
        }
        return Optional.empty();
    }

    public void handleDamageEvent(DamageSource damageSource) {
    }

    public void updateAnimations() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 123;
            this.idleAnimationState.start(0);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    public void tick() {
        if (this.level().isClientSide()) {
            this.updateAnimations();
        }
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        compoundTag.putLong("TankPos", this.blockPosition().asLong());
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        long posLong = compoundTag.getLong("TankPos");
        BlockPos pos = BlockPos.of((long)posLong);
        Vector3d v = new Vector3d((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
        this.setPos(v.x, v.y, v.z);
    }

    public boolean isAlwaysTicking() {
        return true;
    }

    public boolean shouldBeSaved() {
        return true;
    }
}

