/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.client.render;

import com.berksire.furniture.core.block.CofferBlock;
import com.berksire.furniture.core.block.entity.CofferBlockEntity;
import com.berksire.furniture.core.util.FurnitureIdentifier;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;

public class CofferRenderer
implements BlockEntityRenderer<CofferBlockEntity> {
    private static final ResourceLocation TEXTURE = FurnitureIdentifier.parseIdentifier("textures/entity/coffer.png");
    private final ModelPart coffer;
    private final ModelPart top;
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(FurnitureIdentifier.parseIdentifier("coffer"), "main");

    public CofferRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelPart = context.bakeLayer(LAYER_LOCATION);
        this.coffer = modelPart.getChild("coffer");
        ModelPart bottom = this.coffer.getChild("bottom");
        this.top = this.coffer.getChild("top");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition coffer = partdefinition.addOrReplaceChild("coffer", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bottom = coffer.addOrReplaceChild("bottom", CubeListBuilder.create().texOffs(0, 0).addBox(-13.0f, -5.0f, -1.0f, 14.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.0f, (float)0.0f, (float)-4.0f));
        PartDefinition top = coffer.addOrReplaceChild("top", CubeListBuilder.create().texOffs(0, 15).addBox(-13.0f, -3.0f, -1.0f, 14.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-7.0f, -1.0f, 9.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.0f, (float)-5.0f, (float)-4.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void render(CofferBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        float lidAngle = blockEntity.getOpenNess(partialTicks);
        lidAngle = 1.0f - lidAngle;
        lidAngle = 1.0f - (float)Math.pow(lidAngle, 1.0);
        float bounce = (float)Math.sin((double)lidAngle * Math.PI);
        this.top.xRot = lidAngle * 1.5707964f + bounce;
        poseStack.pushPose();
        Direction facing = (Direction)blockEntity.getBlockState().getValue((Property)CofferBlock.FACING);
        switch (facing) {
            case NORTH: {
                poseStack.translate(1.0, 1.0, 0.0);
                break;
            }
            case SOUTH: {
                poseStack.translate(0.0, 1.0, 1.0);
                break;
            }
            case EAST: {
                poseStack.translate(1.0, 1.0, 1.0);
                break;
            }
            case WEST: {
                poseStack.translate(0.0, 1.0, 0.0);
            }
        }
        poseStack.mulPose(new Quaternionf().rotateY((float)Math.toRadians(-facing.toYRot() + 180.0f)));
        poseStack.mulPose(new Quaternionf().rotateX((float)Math.toRadians(180.0)));
        poseStack.translate(-0.5, -0.5, -0.5);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE));
        this.coffer.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        poseStack.popPose();
    }
}

