/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.client.render;

import com.berksire.furniture.client.model.GramophoneModel;
import com.berksire.furniture.core.block.GramophoneBlock;
import com.berksire.furniture.core.block.entity.GramophoneBlockEntity;
import com.berksire.furniture.core.util.FurnitureIdentifier;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;

public class GramophoneRenderer
implements BlockEntityRenderer<GramophoneBlockEntity> {
    private static final ResourceLocation TEXTURE = FurnitureIdentifier.parseIdentifier("textures/entity/gramophone.png");
    private final GramophoneModel<?> model;

    public GramophoneRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new GramophoneModel(context.bakeLayer(GramophoneModel.LAYER_LOCATION));
    }

    public void render(GramophoneBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        BlockState blockState = blockEntity.getBlockState();
        if (blockState.getValue(GramophoneBlock.HALF) == DoubleBlockHalf.UPPER) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        Direction direction = (Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        float rotation = switch (direction) {
            case Direction.NORTH -> 0.0f;
            case Direction.SOUTH -> 180.0f;
            default -> direction.toYRot();
        };
        poseStack.mulPose(new Quaternionf().rotateYXZ((float)Math.toRadians(rotation), 0.0f, 0.0f));
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        ModelPart base = this.model.gramophone.getChild("base");
        this.model.disc.visible = false;
        base.render(poseStack, bufferSource.getBuffer(this.model.renderType(TEXTURE)), combinedLight, OverlayTexture.NO_OVERLAY);
        this.model.disc.visible = true;
        this.model.gramophone.getChild("horn").render(poseStack, bufferSource.getBuffer(this.model.renderType(TEXTURE)), combinedLight, OverlayTexture.NO_OVERLAY);
        if (((Boolean)blockState.getValue((Property)GramophoneBlock.HAS_RECORD)).booleanValue()) {
            float totalGameTime = (float)(Objects.requireNonNull(blockEntity.getLevel()).getGameTime() % 360L) + partialTicks;
            float discRotation = totalGameTime * 5.0f % 360.0f;
            float verticalMovement = (float)Math.sin((double)totalGameTime * 0.1) * 0.002f;
            poseStack.pushPose();
            poseStack.translate(0.5, (double)(0.0f + verticalMovement), -0.5);
            poseStack.translate((double)(this.model.disc.x / 16.0f), 0.0, (double)(this.model.disc.z / 16.0f));
            poseStack.mulPose(new Quaternionf().rotateY((float)Math.toRadians(discRotation)));
            poseStack.translate((double)(-this.model.disc.x / 16.0f), 0.0, (double)(-this.model.disc.z / 16.0f));
            this.model.disc.render(poseStack, bufferSource.getBuffer(this.model.renderType(TEXTURE)), combinedLight, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
        poseStack.popPose();
    }
}

