/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.core.block;

import com.berksire.furniture.core.block.LineConnectingBlock;
import com.berksire.furniture.core.util.FurnitureUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BenchBlock
extends LineConnectingBlock {
    public static final Map<Direction, VoxelShape> SHAPE;
    public static final Map<Direction, VoxelShape> MIDDLE_SHAPE;
    public static final Map<Direction, VoxelShape> LEFT_SHAPE;
    public static final Map<Direction, VoxelShape> RIGHT_SHAPE;
    public static final Map<Direction, VoxelShape> NONE_REST_SHAPE;
    public static final Map<Direction, VoxelShape> LEFT_REST_SHAPE;
    public static final Map<Direction, VoxelShape> RIGHT_REST_SHAPE;
    public static final BooleanProperty REST;
    private static final Supplier<VoxelShape> noneShapeSupplier;
    private static final Supplier<VoxelShape> noneRestShapeSupplier;
    private static final Supplier<VoxelShape> middleShapeSupplier;
    private static final Supplier<VoxelShape> leftShapeSupplier;
    private static final Supplier<VoxelShape> leftRestShapeSupplier;
    private static final Supplier<VoxelShape> rightShapeSupplier;
    private static final Supplier<VoxelShape> rightRestShapeSupplier;

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        boolean rest = (Boolean)state.getValue((Property)REST);
        return (switch ((FurnitureUtil.LineConnectingType)((Object)state.getValue((Property)TYPE))) {
            case FurnitureUtil.LineConnectingType.MIDDLE -> MIDDLE_SHAPE;
            case FurnitureUtil.LineConnectingType.LEFT -> rest ? LEFT_REST_SHAPE : LEFT_SHAPE;
            case FurnitureUtil.LineConnectingType.RIGHT -> rest ? RIGHT_REST_SHAPE : RIGHT_SHAPE;
            default -> rest ? NONE_REST_SHAPE : SHAPE;
        }).get(state.getValue((Property)FACING));
    }

    public BenchBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)REST, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{REST, FACING, TYPE});
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (player.isShiftKeyDown()) {
            return this.toggleRest(blockState, level, blockPos);
        }
        return FurnitureUtil.useItemOn(level, player, interactionHand, blockHitResult, 0.1);
    }

    @NotNull
    public ItemInteractionResult toggleRest(BlockState state, Level world, BlockPos pos) {
        boolean newRestState = (Boolean)state.getValue((Property)REST) == false;
        this.updateConnectedBlocks(state, world, pos, newRestState);
        return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    @Override
    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        FurnitureUtil.LineConnectingType type = this.getType(state, world.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getClockWise())), world.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getCounterClockWise())));
        if (state.getValue((Property)TYPE) != type) {
            state = (BlockState)state.setValue((Property)TYPE, (Comparable)((Object)type));
            world.setBlock(pos, state, 3);
        }
    }

    @Override
    public FurnitureUtil.LineConnectingType getType(BlockState state, BlockState clockwise, BlockState counterClockwise) {
        boolean shape_counterClockwise_same;
        boolean shape_clockwise_same = clockwise.getBlock() == state.getBlock() && clockwise.getValue((Property)FACING) == state.getValue((Property)FACING) && clockwise.getValue((Property)REST) == state.getValue((Property)REST);
        boolean bl = shape_counterClockwise_same = counterClockwise.getBlock() == state.getBlock() && counterClockwise.getValue((Property)FACING) == state.getValue((Property)FACING) && counterClockwise.getValue((Property)REST) == state.getValue((Property)REST);
        if (shape_clockwise_same && !shape_counterClockwise_same) {
            return FurnitureUtil.LineConnectingType.RIGHT;
        }
        if (!shape_clockwise_same && shape_counterClockwise_same) {
            return FurnitureUtil.LineConnectingType.LEFT;
        }
        if (shape_clockwise_same) {
            return FurnitureUtil.LineConnectingType.MIDDLE;
        }
        return FurnitureUtil.LineConnectingType.NONE;
    }

    private void updateConnectedBlocks(BlockState state, Level world, BlockPos pos, boolean newRestState) {
        Direction[] directions;
        world.setBlock(pos, (BlockState)state.setValue((Property)REST, (Comparable)Boolean.valueOf(newRestState)), 3);
        for (Direction direction : directions = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
            BlockPos neighborPos = pos.relative(direction);
            while (world.getBlockState(neighborPos).getBlock() instanceof BenchBlock) {
                world.setBlock(neighborPos, (BlockState)world.getBlockState(neighborPos).setValue((Property)REST, (Comparable)Boolean.valueOf(newRestState)), 3);
                neighborPos = neighborPos.relative(direction);
            }
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        FurnitureUtil.onStateReplaced(world, pos);
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }

    static {
        REST = BooleanProperty.create((String)"rest");
        noneShapeSupplier = () -> {
            VoxelShape shape = Shapes.empty();
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.1875, (double)0.25, (double)0.1875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.0, (double)0.0625, (double)0.9375, (double)0.25, (double)0.1875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.8125, (double)0.1875, (double)0.25, (double)0.9375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.0, (double)0.8125, (double)0.9375, (double)0.25, (double)0.9375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.25, (double)0.0625, (double)0.9375, (double)0.375, (double)0.9375), (BooleanOp)BooleanOp.OR);
            return shape;
        };
        noneRestShapeSupplier = () -> {
            VoxelShape shape = Shapes.empty();
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.1875, (double)0.25, (double)0.1875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.0, (double)0.0625, (double)0.9375, (double)0.25, (double)0.1875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.8125, (double)0.1875, (double)0.25, (double)0.9375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.0, (double)0.8125, (double)0.9375, (double)0.25, (double)0.9375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.25, (double)0.0625, (double)0.9375, (double)0.375, (double)0.9375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.375, (double)0.8125, (double)0.9375, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.375, (double)0.8125, (double)0.1875, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.OR);
            return shape;
        };
        middleShapeSupplier = () -> {
            VoxelShape shape = Shapes.empty();
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.25, (double)0.0625, (double)1.0, (double)0.375, (double)0.9375), (BooleanOp)BooleanOp.OR);
            return shape;
        };
        leftShapeSupplier = () -> {
            VoxelShape shape = Shapes.empty();
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.1875, (double)0.25, (double)0.1875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.8125, (double)0.1875, (double)0.25, (double)0.9375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.25, (double)0.0625, (double)1.0, (double)0.375, (double)0.9375), (BooleanOp)BooleanOp.OR);
            return shape;
        };
        leftRestShapeSupplier = () -> {
            VoxelShape shape = Shapes.empty();
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.1875, (double)0.25, (double)0.1875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.8125, (double)0.1875, (double)0.25, (double)0.9375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.375, (double)0.8125, (double)0.1875, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.25, (double)0.0625, (double)1.0, (double)0.375, (double)0.9375), (BooleanOp)BooleanOp.OR);
            return shape;
        };
        rightShapeSupplier = () -> {
            VoxelShape shape = Shapes.empty();
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.0, (double)0.0625, (double)0.9375, (double)0.25, (double)0.1875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.0, (double)0.8125, (double)0.9375, (double)0.25, (double)0.9375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.25, (double)0.0625, (double)0.9375, (double)0.375, (double)0.9375), (BooleanOp)BooleanOp.OR);
            return shape;
        };
        rightRestShapeSupplier = () -> {
            VoxelShape shape = Shapes.empty();
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.0, (double)0.0625, (double)0.9375, (double)0.25, (double)0.1875), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.0, (double)0.8125, (double)0.9375, (double)0.25, (double)0.9375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.375, (double)0.8125, (double)0.9375, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.OR);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.25, (double)0.0625, (double)0.9375, (double)0.375, (double)0.9375), (BooleanOp)BooleanOp.OR);
            return shape;
        };
        SHAPE = (Map)Util.make(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
                map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, noneShapeSupplier.get()));
            }
        });
        MIDDLE_SHAPE = (Map)Util.make(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
                map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, middleShapeSupplier.get()));
            }
        });
        LEFT_SHAPE = (Map)Util.make(new HashMap(), map -> {
            map.put(Direction.NORTH, FurnitureUtil.rotateShape(Direction.NORTH, Direction.NORTH, rightShapeSupplier.get()));
            map.put(Direction.SOUTH, FurnitureUtil.rotateShape(Direction.NORTH, Direction.SOUTH, rightShapeSupplier.get()));
            map.put(Direction.EAST, FurnitureUtil.rotateShape(Direction.NORTH, Direction.EAST, rightShapeSupplier.get()));
            map.put(Direction.WEST, FurnitureUtil.rotateShape(Direction.NORTH, Direction.WEST, rightShapeSupplier.get()));
        });
        RIGHT_SHAPE = (Map)Util.make(new HashMap(), map -> {
            map.put(Direction.NORTH, FurnitureUtil.rotateShape(Direction.NORTH, Direction.NORTH, leftShapeSupplier.get()));
            map.put(Direction.SOUTH, FurnitureUtil.rotateShape(Direction.NORTH, Direction.SOUTH, leftShapeSupplier.get()));
            map.put(Direction.EAST, FurnitureUtil.rotateShape(Direction.NORTH, Direction.EAST, leftShapeSupplier.get()));
            map.put(Direction.WEST, FurnitureUtil.rotateShape(Direction.NORTH, Direction.WEST, leftShapeSupplier.get()));
        });
        NONE_REST_SHAPE = (Map)Util.make(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
                map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, noneRestShapeSupplier.get()));
            }
        });
        LEFT_REST_SHAPE = (Map)Util.make(new HashMap(), map -> {
            map.put(Direction.NORTH, FurnitureUtil.rotateShape(Direction.NORTH, Direction.NORTH, rightRestShapeSupplier.get()));
            map.put(Direction.SOUTH, FurnitureUtil.rotateShape(Direction.NORTH, Direction.SOUTH, rightRestShapeSupplier.get()));
            map.put(Direction.EAST, FurnitureUtil.rotateShape(Direction.NORTH, Direction.EAST, rightRestShapeSupplier.get()));
            map.put(Direction.WEST, FurnitureUtil.rotateShape(Direction.NORTH, Direction.WEST, rightRestShapeSupplier.get()));
        });
        RIGHT_REST_SHAPE = (Map)Util.make(new HashMap(), map -> {
            map.put(Direction.NORTH, FurnitureUtil.rotateShape(Direction.NORTH, Direction.NORTH, leftRestShapeSupplier.get()));
            map.put(Direction.SOUTH, FurnitureUtil.rotateShape(Direction.NORTH, Direction.SOUTH, leftRestShapeSupplier.get()));
            map.put(Direction.EAST, FurnitureUtil.rotateShape(Direction.NORTH, Direction.EAST, leftRestShapeSupplier.get()));
            map.put(Direction.WEST, FurnitureUtil.rotateShape(Direction.NORTH, Direction.WEST, leftRestShapeSupplier.get()));
        });
    }
}

