/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.core.block;

import com.berksire.furniture.core.util.FurnitureUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CurtainBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING;
    public static final EnumProperty<FurnitureUtil.VerticalConnectingType> TYPE;
    public static final BooleanProperty OPEN;
    public static final BooleanProperty POWERED;
    public static final BooleanProperty WATERLOGGED;
    private final DyeColor color;
    public static final Map<Direction, VoxelShape> SHAPE_TOP_OR_SINGLE;
    public static final Map<Direction, VoxelShape> SHAPE_OTHER;

    public CurtainBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties);
        this.color = color;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(TYPE, (Comparable)((Object)FurnitureUtil.VerticalConnectingType.NONE))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public DyeColor getColor() {
        return this.color;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos clickedPos;
        Direction facing = context.getHorizontalDirection().getOpposite();
        BlockState blockState = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing);
        Level world = context.getLevel();
        if (world.hasNeighborSignal(clickedPos = context.getClickedPos())) {
            blockState = (BlockState)((BlockState)blockState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(true))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(true));
        }
        blockState = (BlockState)blockState.setValue(TYPE, (Comparable)((Object)this.getType(blockState, world.getBlockState(clickedPos.above()), world.getBlockState(clickedPos.below()))));
        return (BlockState)blockState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(clickedPos).getType() == Fluids.WATER));
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (world.isClientSide) {
            return;
        }
        boolean powered = world.hasNeighborSignal(pos);
        if (powered != (Boolean)state.getValue((Property)POWERED)) {
            if ((Boolean)state.getValue((Property)OPEN) != powered) {
                state = (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(powered));
                world.playSound(null, pos, CurtainBlock.Curtainsound(powered), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (((Boolean)(state = (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered))).getValue((Property)WATERLOGGED)).booleanValue()) {
                world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
            }
        }
        FurnitureUtil.VerticalConnectingType type = this.getType(state, world.getBlockState(pos.above()), world.getBlockState(pos.below()));
        if (state.getValue(TYPE) != type) {
            state = (BlockState)state.setValue(TYPE, (Comparable)((Object)type));
        }
        world.setBlock(pos, state, 3);
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        return this.toggleCurtain(blockState, level, blockPos, player);
    }

    public InteractionResult toggleCurtain(BlockState state, Level level, BlockPos pos, Player player) {
        state = (BlockState)state.cycle((Property)OPEN);
        level.setBlock(pos, state, 3);
        if (player == null || !player.isCrouching()) {
            this.toggleCurtain(state, level, pos, (Boolean)state.getValue((Property)OPEN));
        }
        level.playSound(null, pos, CurtainBlock.Curtainsound((Boolean)state.getValue((Property)OPEN)), SoundSource.BLOCKS, 1.0f, 1.0f);
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void toggleCurtain(BlockState state, Level level, BlockPos pos, boolean open) {
        int i;
        BlockState updateState = state;
        BlockPos updatePos = pos;
        if (state.getValue(TYPE) == FurnitureUtil.VerticalConnectingType.MIDDLE || state.getValue(TYPE) == FurnitureUtil.VerticalConnectingType.BOTTOM) {
            BlockState above;
            int heightUp = level.dimensionType().height() - updatePos.getY();
            for (i = 0; i < heightUp && (above = level.getBlockState(updatePos.above())).is(state.getBlock()) && above.getValue((Property)FACING) == updateState.getValue((Property)FACING) && (Boolean)above.getValue((Property)OPEN) != open; ++i) {
                updateState = above;
                updatePos = updatePos.above();
                level.setBlock(updatePos, (BlockState)updateState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
            }
        }
        if (state.getValue(TYPE) == FurnitureUtil.VerticalConnectingType.MIDDLE || state.getValue(TYPE) == FurnitureUtil.VerticalConnectingType.TOP) {
            BlockState below;
            updateState = state;
            updatePos = pos;
            int heightDown = level.dimensionType().minY() - updatePos.getY();
            heightDown = heightDown < 0 ? -heightDown : heightDown;
            for (i = 0; i < heightDown && (below = level.getBlockState(updatePos.below())).is(state.getBlock()) && below.getValue((Property)FACING) == updateState.getValue((Property)FACING) && (Boolean)below.getValue((Property)OPEN) != open; ++i) {
                updateState = below;
                updatePos = updatePos.below();
                level.setBlock(updatePos, (BlockState)updateState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
            }
        }
    }

    public static SoundEvent Curtainsound(boolean open) {
        if (open) {
            return SoundEvents.WOOL_FALL;
        }
        return SoundEvents.WOOL_PLACE;
    }

    public FurnitureUtil.VerticalConnectingType getType(BlockState state, BlockState above, BlockState below) {
        boolean shape_below_same;
        boolean shape_above_same = above.getBlock() == state.getBlock() && above.getValue((Property)FACING) == state.getValue((Property)FACING) && above.getValue((Property)OPEN) == state.getValue((Property)OPEN);
        boolean bl = shape_below_same = below.getBlock() == state.getBlock() && below.getValue((Property)FACING) == state.getValue((Property)FACING) && below.getValue((Property)OPEN) == state.getValue((Property)OPEN);
        if (shape_above_same && !shape_below_same) {
            return FurnitureUtil.VerticalConnectingType.BOTTOM;
        }
        if (!shape_above_same && shape_below_same) {
            return FurnitureUtil.VerticalConnectingType.TOP;
        }
        if (shape_above_same) {
            return FurnitureUtil.VerticalConnectingType.MIDDLE;
        }
        return FurnitureUtil.VerticalConnectingType.NONE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, TYPE, OPEN, POWERED, WATERLOGGED});
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    private static VoxelShape makeTopOrSingleShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.8125, (double)0.9375, (double)1.0, (double)0.9375, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.875, (double)1.0, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    private static VoxelShape makeOtherShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.875, (double)1.0, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        FurnitureUtil.VerticalConnectingType type = (FurnitureUtil.VerticalConnectingType)((Object)state.getValue(TYPE));
        if (type == FurnitureUtil.VerticalConnectingType.TOP || type == FurnitureUtil.VerticalConnectingType.NONE) {
            return SHAPE_TOP_OR_SINGLE.get(direction);
        }
        return SHAPE_OTHER.get(direction);
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public boolean isOcclusionShapeFullBlock(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    static {
        SHAPE_TOP_OR_SINGLE = (Map)Util.make(new HashMap(), map -> {
            Supplier<VoxelShape> voxelShapeSupplier = CurtainBlock::makeTopOrSingleShape;
            for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
                map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
            }
        });
        SHAPE_OTHER = (Map)Util.make(new HashMap(), map -> {
            Supplier<VoxelShape> voxelShapeSupplier = CurtainBlock::makeOtherShape;
            for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
                map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
            }
        });
        FACING = BlockStateProperties.HORIZONTAL_FACING;
        TYPE = FurnitureUtil.VerticalConnectingType.VERTICAL_CONNECTING_TYPE;
        OPEN = BlockStateProperties.OPEN;
        POWERED = BlockStateProperties.POWERED;
        WATERLOGGED = BlockStateProperties.WATERLOGGED;
    }
}

